package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.entity.ElectronicAccountBillDayStatistics;
import com.bizunited.empower.business.payment.service.ElectronicAccountBillDayStatisticsService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 电子账户每日统计数据控制器
 * @Author: Paul Chan
 * @Date: 2021/4/25 下午2:19
 */
@RestController
@RequestMapping("/v1/electronicAccount/bills/statistics")
public class ElectronicAccountBillDayStatisticsController extends BaseController {
  private final static Logger LOGGER = LoggerFactory.getLogger(ElectronicAccountBillDayStatisticsController.class);

  @Autowired
  private ElectronicAccountBillDayStatisticsService electronicAccountBillDayStatisticsService;

  /**
   * 多条件分页查询
   * @param accountId
   * @param startDate
   * @param endDate
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "多条件分页查询", notes = "分页查询，分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByConditions(@PageableDefault(50) Pageable pageable,
                                        @RequestParam(required = false) @ApiParam("账户ID") String accountId,
                                        @DateTimeFormat(pattern = "yyyy-MM-dd") @RequestParam(required = false) @ApiParam("开始日期(yyyy-MM-dd)") Date startDate,
                                        @DateTimeFormat(pattern = "yyyy-MM-dd") @RequestParam(required = false) @ApiParam("结束日期(包含)(yyyy-MM-dd)") Date endDate) {
    try {
      Map<String, Object> conditions = Maps.newHashMap();
      conditions.put("accountId", accountId);
      conditions.put("startDate", startDate);
      conditions.put("endDate", endDate);
      Page<ElectronicAccountBillDayStatistics> page = electronicAccountBillDayStatisticsService.findByConditions(conditions, pageable);
      return this.buildHttpResultW(page);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 获取最近指定天数的数据
   * @param days
   * @return
   */
  @GetMapping("findByDays")
  @ApiOperation("获取最近指定天数的数据")
  public ResponseModel findByDays(@RequestParam @ApiParam("天数，默认10") Integer days) {
    try {
      List<ElectronicAccountBillDayStatistics> statistics = electronicAccountBillDayStatisticsService.findByDays(days);
      return this.buildHttpResultW(statistics);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
