package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.entity.ElectronicAccountFailureRecord;
import com.bizunited.empower.business.payment.service.ElectronicAccountFailureRecordService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 电子账户失败记录控制器， 基于HTTP Restful风格
 *
 * @Author: Paul Chan
 * @Date: 2021/4/9 下午5:20
 */
@RestController
@RequestMapping("/v1/electronicAccountFailureRecords")
public class ElectronicAccountFailureRecordController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ElectronicAccountFailureRecordController.class);

  @Autowired
  private ElectronicAccountFailureRecordService electronicAccountFailureRecordService;

  /**
   * 新增
   * @param record
   * @return
   */
  @PostMapping("")
  @ApiOperation("新增")
  public ResponseModel create(@RequestBody @ApiParam("失败记录") ElectronicAccountFailureRecord record) {
    try {
      ElectronicAccountFailureRecord result = electronicAccountFailureRecordService.create(record);
      return this.buildHttpResultW(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据电子账户ID查询
   * @param electronicAccountId
   * @return
   */
  @GetMapping("findByElectronicAccountId")
  @ApiOperation("根据电子账户ID查询")
  public ResponseModel findByElectronicAccountId(@RequestParam("electronicAccountId") @ApiParam("电子账户ID") String electronicAccountId) {
    try {
      List<ElectronicAccountFailureRecord> records = electronicAccountFailureRecordService.findByElectronicAccountId(electronicAccountId);
      return this.buildHttpResultW(records);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
