package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.service.ElectronicAccountRateVoService;
import com.bizunited.empower.business.payment.vo.ElectronicAccountRateVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 电子账户的费率控制器
 * @Author: Paul Chan
 * @Date: 2021/4/27 下午2:03
 */
@RestController
@RequestMapping("/v1/electronicAccountRateVo")
public class ElectronicAccountRateVoController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(ElectronicAccountRateVoController.class);

  @Autowired
  private ElectronicAccountRateVoService electronicAccountRateVoService;

  /**
   * 获取当前经销商的费率
   * @return
   */
  @GetMapping("findByTenant")
  @ApiOperation("获取当前经销商的费率")
  public ResponseModel findByTenant() {
    try {
      List<ElectronicAccountRateVo> rates = electronicAccountRateVoService.findByTenant();
      return this.buildHttpResultW(rates);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
