package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.service.ElectronicAccountStatisticsVoService;
import com.bizunited.empower.business.payment.vo.ElectronicAccountStatisticsVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 电子账户统计vo控制器
 * @Author: Paul Chan
 * @Date: 2021/4/21 上午11:32
 */
@RestController
@RequestMapping("/v1/electronicAccount/statistics")
public class ElectronicAccountStatisticsVoController extends BaseController {
  private static final Logger LOGGER = LoggerFactory.getLogger(ElectronicAccountStatisticsVoController.class);

  @Autowired
  private ElectronicAccountStatisticsVoService electronicAccountStatisticsVoService;

  /**
   * 获取当前经销商的统计信息
   * @return
   */
  @GetMapping("findByTenant")
  @ApiOperation("获取当前经销商的统计信息")
  public ResponseModel findByTenant() {
    try {
      ElectronicAccountStatisticsVo statisticsVo = electronicAccountStatisticsVoService.findByTenant();
      return this.buildHttpResultW(statisticsVo);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据经销商ID获取统计信息
   * @return
   */
  @GetMapping("findByAccountId")
  @ApiOperation("根据经销商ID获取统计信息")
  public ResponseModel findByAccountId(@RequestParam @ApiParam("电子账户ID") String accountId) {
    try {
      ElectronicAccountStatisticsVo statisticsVo = electronicAccountStatisticsVoService.findByAccountId(accountId);
      return this.buildHttpResultW(statisticsVo);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
