package com.bizunited.empower.business.payment.controller;
import com.bizunited.empower.business.payment.entity.ReceiptAttachment;
import com.bizunited.empower.business.payment.service.ReceiptAttachmentService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * ReceiptFile业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/receiptAttachment")
public class ReceiptAttachmentController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ReceiptAttachmentController.class);
  
  @Autowired
  private ReceiptAttachmentService receiptAttachmentService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建receiptFile中的基本信息以外，还可以对receiptFile中属于OneToMany关联的明细信息一同进行创建注意：基于（ReceiptFile）模型的创建操作传入的receiptFileJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建receiptFile中的基本信息以外，还可以对receiptFile中属于OneToMany关联的明细信息一同进行创建注意：基于（ReceiptFile）模型的创建操作传入的receiptFileJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="receiptFile" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建receiptFile中的基本信息以外，还可以对receiptFile中属于OneToMany关联的明细信息一同进行创建注意：基于（ReceiptFile）模型的创建操作传入的receiptFileJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") ReceiptAttachment receiptAttachment) {
    try {
      ReceiptAttachment current = this.receiptAttachmentService.create(receiptAttachment);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（ReceiptFile）的修改操作传入的receiptFileJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（ReceiptFile）的修改操作传入的receiptFileJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="receiptFile" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（ReceiptFile）的修改操作传入的receiptFileJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") ReceiptAttachment receiptAttachment) {
    try {
      ReceiptAttachment current = this.receiptAttachmentService.update(receiptAttachment);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      ReceiptAttachment current = this.receiptAttachmentService.findById(id);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value="/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      this.receiptAttachmentService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照ReceiptFile实体中的（receiptInfo）关联的 收款单编号进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param receiptInfo 关联的 收款单编号
   */
  @ApiOperation(value = "按照ReceiptFile实体中的（receiptInfo）关联的 收款单编号进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByReceiptInfo" , method={RequestMethod.GET})
  public ResponseModel findDetailsByReceiptInfo(@RequestParam("receiptInfo") @ApiParam("关联的 收款单编号") String receiptInfo) {
    try { 
      Set<ReceiptAttachment> result = this.receiptAttachmentService.findDetailsByReceiptInfo(receiptInfo);
      return this.buildHttpResultW(result, new String[]{"receiptInfo"}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照ReceiptFile实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照ReceiptFile实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      ReceiptAttachment result = this.receiptAttachmentService.findDetailsById(id);
      return this.buildHttpResultW(result, "receiptInfo");
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
} 
