package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.service.ReceivableDashBoardVoService;
import com.bizunited.empower.business.payment.vo.ReceivableDashBoardVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 应收账款统计数据控制器
 *
 * @author Keller
 */
@RestController
@RequestMapping("/v1/receivableDashBoard")
public class ReceivableDashBoardVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ReceivableDashBoardVoController.class);
  @Autowired
  private ReceivableDashBoardVoService receivableDashBoardVoService;

  /**
   * 查询仪表盘统计数据
   */
  @ApiOperation(value = "查询仪表盘统计数据")
  @GetMapping(value = "")
  public ResponseModel findStatistics() {
    try {
      ReceivableDashBoardVo current = this.receivableDashBoardVoService.statistics();
      return this.buildHttpResultW(current);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
