package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.entity.SupplierPaymentInfo;
import com.bizunited.empower.business.payment.service.SupplierPaymentInfoService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Date;

/**
 * SupplierReceivableInfo业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author Keller
 */
@RestController
@RequestMapping("/v1/supplierPayment")
public class SupplierPaymentInfoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SupplierPaymentInfoController.class);
  @Autowired
  private SupplierPaymentInfoService supplierPaymentInfoService;

  /**
   * 通过单据号新增采购应收账款
   */
  @ApiOperation(value = "通过单据号新增采购应收账款")
  @PostMapping(value = "createByAssociatedCode")
  public ResponseModel createByAssociatedCode(@ApiParam("单据号") @RequestParam("associatedCode") String associatedCode, @ApiParam("金额") @RequestParam("amount") BigDecimal amount, @ApiParam("供应商编号") @RequestParam("supplierCode") String supplierCode, @ApiParam("供应商名称") @RequestParam("supplierName") String supplierName) {
    try {
      SupplierPaymentInfo current = this.supplierPaymentInfoService.createByAssociatedCode(supplierCode, supplierName, associatedCode, amount);
      return this.buildHttpResultW(current);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 确认应收账款信息
   */
  @ApiOperation(value = "确认应收账款信息")
  @PostMapping(value = "confirm")
  public ResponseModel confirm(@ApiParam("付款单号") @RequestParam("payCode") String payCode, @ApiParam("支付时间") @RequestParam("payTime") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date payTime) {
    try {
      SupplierPaymentInfo current = this.supplierPaymentInfoService.confirmPay(payCode, payTime);
      return this.buildHttpResultW(current);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 通过关联单据查询采购付款单
   *
   * @param associatedCode
   * @return
   */
  @GetMapping("findByAssociatedCode")
  @ApiOperation(value = "通过关联单据查询采购付款单")
  public ResponseModel findByAssociatedCode(@RequestParam String associatedCode) {
    try {
      SupplierPaymentInfo supplierPaymentInfo = this.supplierPaymentInfoService.findByAssociatedCode(associatedCode);
      return this.buildHttpResultW(supplierPaymentInfo);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 取消应收账款信息
   */
  @ApiOperation(value = "取消应付账款信息")
  @PostMapping(value = "cancel")
  public ResponseModel cancel(@ApiParam("关联单号") @RequestParam("associatedCode") String associatedCode) {
    try {
      this.supplierPaymentInfoService.cancelByAssociatedCode(associatedCode);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
