package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.entity.SupplierReceivableInfo;
import com.bizunited.empower.business.payment.service.SupplierReceivableInfoService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Date;

/**
 * SupplierReceivableInfo业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author Keller
 */
@RestController
@RequestMapping("/v1/supplierReceivable")
public class SupplierReceivableInfoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SupplierReceivableInfoController.class);
  @Autowired
  private SupplierReceivableInfoService supplierReceivableInfoService;

  /**
   * 通过单据号新增采购应收账款
   */
  @ApiOperation(value = "通过单据号新增采购应收账款")
  @PostMapping(value = "createByAssociatedCode")
  public ResponseModel createByAssociatedCode(@ApiParam("单据号") @RequestParam("associatedCode") String associatedCode, @ApiParam("金额") @RequestParam("amount") BigDecimal amount, @ApiParam("供应商编号") @RequestParam("supplierCode") String supplierCode, @ApiParam("供应商名称") @RequestParam("supplierName") String supplierName) {
    try {
      SupplierReceivableInfo current = this.supplierReceivableInfoService.createByAssociatedCode(supplierCode, supplierName, associatedCode, amount);
      return this.buildHttpResultW(current);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 确认应收账款信息
   */
  @ApiOperation(value = "确认应收账款信息")
  @PostMapping(value = "confirm")
  public ResponseModel confirm(@ApiParam("收款单号") @RequestParam("receiptCode") String receiptCode,@ApiParam("收款时间") @RequestParam("receivableTime") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date receivableTime) {
    try {
      SupplierReceivableInfo current = supplierReceivableInfoService.confirmReceive(receiptCode,receivableTime);
      return this.buildHttpResultW(current);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 通过关联单据查询采购应收款单
   *
   * @param associatedCode
   * @return
   */
  @GetMapping("findByAssociatedCode")
  @ApiOperation(value = "通过关联单据查询应收款单")
  public ResponseModel findByAssociatedCode(@RequestParam String associatedCode) {
    try {
      SupplierReceivableInfo supplierPaymentInfo = supplierReceivableInfoService.findByAssociatedCode(associatedCode);
      return this.buildHttpResultW(supplierPaymentInfo);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 取消应收账款信息
   */
  @ApiOperation(value = "取消应收账款信息")
  @PostMapping(value = "cancel")
  public ResponseModel cancel(@ApiParam("关联单号") @RequestParam("associatedCode") String associatedCode) {
    try {
      supplierReceivableInfoService.cancelByAssociatedCode(associatedCode);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
