package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.service.SupplierReceivableInfoService;
import com.bizunited.empower.business.payment.vo.SupplierReceivableInfoVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * SupplierReceivableInfoVo业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author Keller
 */
@RestController
@RequestMapping("/v1/supplierReceivable")
public class SupplierReceivableInfoVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SupplierReceivableInfoVoController.class);
  @Autowired
  private SupplierReceivableInfoService supplierReceivableInfoService;

  /**
   * 多条件分页查询
   *
   * @param pageable
   * @return
   */
  @GetMapping("findByConditionsForAssociated")
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认10")
  public ResponseModel findByConditionsForAssociated(@PageableDefault(10) Pageable pageable,
                                                   HttpServletRequest request) {
    try {
      Map<String, Object> params = new HashMap<>();
      Enumeration<String> names = request.getParameterNames();
      if (names != null) {
        while (names.hasMoreElements()) {
          String name = names.nextElement();
          String[] values = request.getParameterValues(name);
          if (values != null && values.length == 1) {
            params.put(name, values[0]);
          } else if (values != null && values.length > 1) {
            params.put(name, values);
          }
        }
      }
      InvokeParams conditions = new InvokeParams();
      conditions.putInvokeParams(params);
      Page<SupplierReceivableInfoVo> page = this.supplierReceivableInfoService.findByConditionsForAssociated(pageable, conditions);
      return this.buildHttpResultW(page);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
