package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 电子账户银行信息VO
 * @Author: Paul Chan
 * @Date: 2021/4/8 下午2:25
 */
@ApiModel(value = "ElectronicAccountBankDto", description = "电子账户银行信息VO")
@SaturnEntity(name = "ElectronicAccountBankDto", description = "电子账户银行信息VO")
public class ElectronicAccountBankDto extends UuidVo {

  private static final long serialVersionUID = 3231022147149025724L;
  /**
   * 状态：0：待验证，1：正常，2：已解绑
   */
  @SaturnColumn(description = "状态：0：待验证，1：正常，2：已解绑")
  @ApiModelProperty("状态：0：待验证，1：正常，2：已解绑")
  private Integer state;

  /**
   * 经营者姓名
   */
  @ApiModelProperty("经营者姓名")
  @SaturnColumn(description = "经营者姓名")
  private String managementName;

  /**
   * 身份证号
   */
  @ApiModelProperty("身份证号")
  @SaturnColumn(description = "身份证号")
  private String idCardNo;

  /**
   * 银行ID
   */
  @ApiModelProperty("银行ID")
  @SaturnColumn(description = "银行ID")
  private String bankId;

  /**
   * 银行卡账户名称
   */
  @ApiModelProperty("银行卡账户名称")
  @SaturnColumn(description = "银行卡账户名称")
  private String bankCardAccountName;

  /**
   * 银行卡号
   */
  @ApiModelProperty("银行卡号")
  @SaturnColumn(description = "银行卡号")
  private String bankCardNo;

  /**
   * 开户银行
   */
  @ApiModelProperty("开户银行")
  @SaturnColumn(description = "开户银行")
  private String bankName;

  /**
   * 分支行名称
   */
  @ApiModelProperty("分支行名称")
  @SaturnColumn(description = "分支行名称")
  private String bankBranchName;

  /**
   * 银行卡预留手机号
   */
  @ApiModelProperty("银行卡预留手机号")
  @SaturnColumn(description = "银行卡预留手机号")
  private String mobile;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @SaturnColumn(description = "省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  @SaturnColumn(description = "省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @SaturnColumn(description = "市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  @SaturnColumn(description = "市名称")
  private String cityName;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  @SaturnColumn(description = "区编码")
  private String districtCode;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  @SaturnColumn(description = "区名称")
  private String districtName;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.ManyToOne)
  private ElectronicAccountDto electronicAccount;

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getManagementName() {
    return managementName;
  }

  public void setManagementName(String managementName) {
    this.managementName = managementName;
  }

  public String getBankId() {
    return bankId;
  }

  public void setBankId(String bankId) {
    this.bankId = bankId;
  }

  public String getIdCardNo() {
    return idCardNo;
  }

  public void setIdCardNo(String idCardNo) {
    this.idCardNo = idCardNo;
  }

  public String getBankCardAccountName() {
    return bankCardAccountName;
  }

  public void setBankCardAccountName(String bankCardAccountName) {
    this.bankCardAccountName = bankCardAccountName;
  }

  public String getBankCardNo() {
    return bankCardNo;
  }

  public void setBankCardNo(String bankCardNo) {
    this.bankCardNo = bankCardNo;
  }

  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  public String getBankBranchName() {
    return bankBranchName;
  }

  public void setBankBranchName(String bankBranchName) {
    this.bankBranchName = bankBranchName;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getProvinceCode() {
    return provinceCode;
  }

  public void setProvinceCode(String provinceCode) {
    this.provinceCode = provinceCode;
  }

  public String getProvinceName() {
    return provinceName;
  }

  public void setProvinceName(String provinceName) {
    this.provinceName = provinceName;
  }

  public String getCityCode() {
    return cityCode;
  }

  public void setCityCode(String cityCode) {
    this.cityCode = cityCode;
  }

  public String getCityName() {
    return cityName;
  }

  public void setCityName(String cityName) {
    this.cityName = cityName;
  }

  public String getDistrictCode() {
    return districtCode;
  }

  public void setDistrictCode(String districtCode) {
    this.districtCode = districtCode;
  }

  public String getDistrictName() {
    return districtName;
  }

  public void setDistrictName(String districtName) {
    this.districtName = districtName;
  }

  public ElectronicAccountDto getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccountDto electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
