package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 电子账户证件资料
 *
 * @Author: Paul Chan
 * @Date: 2021/4/8 上午10:54
 */
@ApiModel(value = "ElectronicAccountCertificate", description = "电子账户证件资料")
public class ElectronicAccountCertificateDto extends UuidVo {

  private static final long serialVersionUID = -459217998356977006L;
  /**
   * 营业执照图片文件夹
   */
  @ApiModelProperty("营业执照图片文件夹")
  @SaturnColumn(description = "营业执照图片文件夹")
  private String businessLicensePath;

  /**
   * 营业执照图片文件名
   */
  @ApiModelProperty("营业执照图片文件名")
  @SaturnColumn(description = "营业执照图片文件名")
  private String businessLicenseFilename;

  /**
   * 营业执照图片文件（base64）
   */
  @ApiModelProperty("营业执照图片文件（base64）")
  @SaturnColumn(description = "营业执照图片文件（base64）")
  private String businessLicenseFile;

  /**
   * 个体工商注册号码
   */
  @ApiModelProperty("个体工商注册号码")
  @SaturnColumn(description = "个体工商注册号码")
  private String businessNo;

  /**
   * 个体工商字号
   */
  @ApiModelProperty("个体工商字号")
  @SaturnColumn(description = "个体工商字号")
  private String businessShopName;

  /**
   * 营业执照发证日
   */
  @ApiModelProperty("营业执照发证日")
  @SaturnColumn(description = "营业执照发证日")
  private Date businessLicenseIssueDate;

  /**
   * 营业执照到期日
   */
  @ApiModelProperty("营业执照到期日")
  @SaturnColumn(description = "营业执照到期日")
  private Date businessLicenseExpireDate;

  /**
   * 形成形式 1:个人经营,2:家庭经营
   */
  @ApiModelProperty("形成形式 1:个人经营,2:家庭经营")
  @SaturnColumn(description = "形成形式 1:个人经营,2:家庭经营")
  private String orgType;

  /**
   * 经营地址
   */
  @ApiModelProperty("经营地址")
  @SaturnColumn(description = "经营地址")
  private String address;

  /**
   * 经营范围
   */
  @ApiModelProperty("经营范围")
  @SaturnColumn(description = "经营范围")
  private String businessScope;

  /**
   * 身份证正面文件夹
   */
  @ApiModelProperty("身份证正面文件夹")
  @SaturnColumn(description = "身份证正面文件夹")
  private String idCardFrontPath;

  /**
   * 身份证正面文件名
   */
  @ApiModelProperty("身份证正面文件名")
  @SaturnColumn(description = "身份证正面文件名")
  private String idCardFrontFilename;

  /**
   * 身份证正面文件(base64)
   */
  @ApiModelProperty("身份证正面文件(base64)")
  @SaturnColumn(description = "身份证正面文件(base64)")
  private String idCardFrontFile;

  /**
   * 身份证背面文件夹
   */
  @ApiModelProperty("身份证背面文件夹")
  @SaturnColumn(description = "身份证背面文件夹")
  private String idCardBackPath;

  /**
   * 身份证背面文件名
   */
  @ApiModelProperty("身份证背面文件名")
  @SaturnColumn(description = "身份证背面文件名")
  private String idCardBackFilename;

  /**
   * 身份证背面文件名(base64)
   */
  @ApiModelProperty("身份证背面文件名(base64)")
  @SaturnColumn(description = "身份证背面文件名(base64)")
  private String idCardBackFile;

  /**
   * 身份证号
   */
  @ApiModelProperty("身份证号")
  @SaturnColumn(description = "身份证号")
  private String idCardNo;

  /**
   * 身份证发证日期
   */
  @ApiModelProperty("身份证发证日期")
  @SaturnColumn(description = "身份证发证日期")
  private Date idCardIssueDate;

  /**
   * 身份证过期日期
   */
  @ApiModelProperty("身份证过期日期")
  @SaturnColumn(description = "身份证过期日期")
  private Date idCardExpireDate;

  //  企业开户

  /**
   * 统一社会信用代码
   */
  @ApiModelProperty("统一社会信用代码")
  @SaturnColumn(description = "统一社会信用代码")
  private String socialCreditCode;

  /**
   * 注册资本
   */
  @ApiModelProperty("注册资本")
  @SaturnColumn(description = "注册资本")
  private BigDecimal registeredCapital;

  /**
   * 法人姓名
   */
  @ApiModelProperty("法人姓名")
  @SaturnColumn(description = "法人姓名")
  private String legalPersonName;

  /**
   * 法人手机号
   */
  @ApiModelProperty("法人手机号")
  @SaturnColumn(description = "法人手机号")
  private String legalPersonMobile;

  /**
   * 法人邮箱
   */
  @ApiModelProperty("法人邮箱")
  @SaturnColumn(description = "法人邮箱")
  private String legalPersonEmail;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
  private ElectronicAccountDto electronicAccount;

  public String getBusinessLicensePath() {
    return businessLicensePath;
  }

  public void setBusinessLicensePath(String businessLicensePath) {
    this.businessLicensePath = businessLicensePath;
  }

  public String getBusinessLicenseFilename() {
    return businessLicenseFilename;
  }

  public void setBusinessLicenseFilename(String businessLicenseFilename) {
    this.businessLicenseFilename = businessLicenseFilename;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public String getBusinessShopName() {
    return businessShopName;
  }

  public void setBusinessShopName(String businessShopName) {
    this.businessShopName = businessShopName;
  }

  public Date getBusinessLicenseIssueDate() {
    return businessLicenseIssueDate;
  }

  public void setBusinessLicenseIssueDate(Date businessLicenseIssueDate) {
    this.businessLicenseIssueDate = businessLicenseIssueDate;
  }

  public Date getBusinessLicenseExpireDate() {
    return businessLicenseExpireDate;
  }

  public void setBusinessLicenseExpireDate(Date businessLicenseExpireDate) {
    this.businessLicenseExpireDate = businessLicenseExpireDate;
  }

  public String getOrgType() {
    return orgType;
  }

  public void setOrgType(String orgType) {
    this.orgType = orgType;
  }

  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public String getBusinessScope() {
    return businessScope;
  }

  public void setBusinessScope(String businessScope) {
    this.businessScope = businessScope;
  }

  public String getIdCardFrontPath() {
    return idCardFrontPath;
  }

  public void setIdCardFrontPath(String idCardFrontPath) {
    this.idCardFrontPath = idCardFrontPath;
  }

  public String getIdCardFrontFilename() {
    return idCardFrontFilename;
  }

  public void setIdCardFrontFilename(String idCardFrontFilename) {
    this.idCardFrontFilename = idCardFrontFilename;
  }

  public String getIdCardBackPath() {
    return idCardBackPath;
  }

  public void setIdCardBackPath(String idCardBackPath) {
    this.idCardBackPath = idCardBackPath;
  }

  public String getIdCardBackFilename() {
    return idCardBackFilename;
  }

  public void setIdCardBackFilename(String idCardBackFilename) {
    this.idCardBackFilename = idCardBackFilename;
  }

  public String getIdCardNo() {
    return idCardNo;
  }

  public void setIdCardNo(String idCardNo) {
    this.idCardNo = idCardNo;
  }

  public Date getIdCardIssueDate() {
    return idCardIssueDate;
  }

  public void setIdCardIssueDate(Date idCardIssueDate) {
    this.idCardIssueDate = idCardIssueDate;
  }

  public Date getIdCardExpireDate() {
    return idCardExpireDate;
  }

  public void setIdCardExpireDate(Date idCardExpireDate) {
    this.idCardExpireDate = idCardExpireDate;
  }

  public String getSocialCreditCode() {
    return socialCreditCode;
  }

  public void setSocialCreditCode(String socialCreditCode) {
    this.socialCreditCode = socialCreditCode;
  }

  public BigDecimal getRegisteredCapital() {
    return registeredCapital;
  }

  public void setRegisteredCapital(BigDecimal registeredCapital) {
    this.registeredCapital = registeredCapital;
  }

  public String getLegalPersonName() {
    return legalPersonName;
  }

  public void setLegalPersonName(String legalPersonName) {
    this.legalPersonName = legalPersonName;
  }

  public String getLegalPersonMobile() {
    return legalPersonMobile;
  }

  public void setLegalPersonMobile(String legalPersonMobile) {
    this.legalPersonMobile = legalPersonMobile;
  }

  public String getLegalPersonEmail() {
    return legalPersonEmail;
  }

  public void setLegalPersonEmail(String legalPersonEmail) {
    this.legalPersonEmail = legalPersonEmail;
  }

  public String getBusinessLicenseFile() {
    return businessLicenseFile;
  }

  public void setBusinessLicenseFile(String businessLicenseFile) {
    this.businessLicenseFile = businessLicenseFile;
  }

  public String getIdCardFrontFile() {
    return idCardFrontFile;
  }

  public void setIdCardFrontFile(String idCardFrontFile) {
    this.idCardFrontFile = idCardFrontFile;
  }

  public String getIdCardBackFile() {
    return idCardBackFile;
  }

  public void setIdCardBackFile(String idCardBackFile) {
    this.idCardBackFile = idCardBackFile;
  }

  public ElectronicAccountDto getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccountDto electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
