package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.common.vo.TenantOpVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Set;

/**
 * 电子账户
 *
 * @Author: Paul Chan
 * @Date: 2021/4/7 下午5:43
 */
@ApiModel(value = "ElectronicAccount", description = "电子账户")
public class ElectronicAccountDto extends TenantOpVo {

  private static final long serialVersionUID = -5476304159680502204L;

  /**
   * 由SaaS平台确认的，为该新的租户服务的资源桶的唯一编号,
   */
  @ApiModelProperty("资源桶的唯一编号")
  @SaturnColumn(description = "资源桶的唯一编号")
  private String bucketCode;

  /**
   * 厂商编码
   */
  @ApiModelProperty("厂商编码")
  @SaturnColumn(description = "厂商编码")
  private String appCode;

  /**
   * 账户绑定的唯一标识
   */
  @ApiModelProperty("账户绑定的唯一标识")
  @SaturnColumn(description = "账户绑定的唯一标识")
  private String userId;

  /**
   * 1：待审核，2：审核失败，3：预审成功，4：采集失败，5：待开户，6：开户失败，7：待绑卡，8：绑卡失败，9：待验证
   * ，10：验证失败，11：待签约，12：签约失败，13：待进件，14：进件中，15：进件失败，16：已启用
   */
  @SaturnColumn(description = "1：待审核，2：审核失败，3：预审成功，4：采集失败，5：待开户，6：开户失败，7：待绑卡，8：绑卡失败，9：待验证\n" +
      " ，10：验证失败，11：待签约，12：签约失败，13：待进件，14：进件中，15：进件失败，16：已启用")
  @ApiModelProperty("1：待审核，2：审核失败，3：预审成功，4：采集失败，5：待开户，6：开户失败，7：待绑卡，8：绑卡失败，9：待验证\n" +
      "  ，10：验证失败，11：待签约，12：签约失败，13：待进件，14：进件中，15：进件失败，16：已启用")
  private Integer applyState;

  /**
   * 账单周期
   */
  @ApiModelProperty("账单周期")
  @SaturnColumn(description = "账单周期")
  private String billingCycle;

  /**
   * 最后失败原因
   */
  @ApiModelProperty("最后失败原因")
  @SaturnColumn(description = "最后失败原因")
  private String latestFailureReason;

  /**
   * 状态：0：申请中，1：已启用，3：已冻结
   */
  @ApiModelProperty("状态：0：申请中，1：已启用，3：已冻结")
  @SaturnColumn(description = "状态：0：申请中，1：已启用，3：已冻结")
  private Integer state;

  /**
   *  绑卡状态 1.未绑卡 2.已绑卡 3.绑卡失败
   */
  @ApiModelProperty("绑卡状态 1.未绑卡 2.已绑卡 3.绑卡失败")
  @SaturnColumn(description = "绑卡状态 1.未绑卡 2.已绑卡 3.绑卡失败")
  private Integer tiedCardStatus;

  /**
   * 类型: 1、个体工商户，2：企业开户
   */
  @ApiModelProperty("类型: 1、个体工商户，2：企业开户")
  @SaturnColumn(description = "类型: 1、个体工商户，2：企业开户")
  private Integer type;

  /**
   * 应用类型: 参见：com.bizunited.operate.common.enums.AppType
   */
  @ApiModelProperty("应用类型")
  @SaturnColumn(description = "应用类型")
  private Integer appType;

  /**
   * 签约人类型: 1、企业法人，2：经办人
   */
  @ApiModelProperty("签约人类型: 1、企业法人，2：经办人")
  @SaturnColumn(description = "签约人类型: 1、企业法人，2：经办人")
  private Integer signerType;

  /**
   * 经办人姓名
   */
  @ApiModelProperty("经办人姓名")
  @SaturnColumn(description = "经办人姓名")
  private String signerName;

  /**
   * 经办人身份证号
   */
  @ApiModelProperty("经办人身份证号")
  @SaturnColumn(description = "经办人身份证号")
  private String signerIdCardNo;

  /**
   * 经办人手机号码
   */
  @ApiModelProperty("经办人手机号码")
  @SaturnColumn(description = "经办人手机号码")
  private String signerMobile;

  /**
   * 商户编号（中心审核通过后返回的编号）
   */
  @ApiModelProperty("商户编号（中心审核通过后返回的编号）")
  @SaturnColumn(description = "商户编号（中心审核通过后返回的编号）")
  private String merchantCode;

  /**
   * 商户名称（中心审核通过后返回的商户名称）
   */
  @ApiModelProperty("商户名称（中心审核通过后返回的商户名称）")
  @SaturnColumn(description = "商户名称（中心审核通过后返回的商户名称）")
  private String merchantName;

  /**
   * 开通时间
   */
  @ApiModelProperty("开通时间")
  @SaturnColumn(description = "开通时间")
  private Date openTime;

  /**
   * 到期时间
   */
  @ApiModelProperty("到期时间")
  @SaturnColumn(description = "到期时间")
  private Date expireTime;

  /**
   * 预审核时间
   */
  @ApiModelProperty("预审核时间")
  @SaturnColumn(description = "预审核时间")
  private Date preApplyTime;

  /**
   * 复审核时间
   */
  @ApiModelProperty("复审核时间")
  @SaturnColumn(description = "复审核时间")
  private Date repeatedApplyTime;

  /**
   * 签约时间
   */
  @ApiModelProperty("签约时间")
  @SaturnColumn(description = "签约时间")
  private Date signTime;

  /**
   *  业务端ID
   */
  @ApiModelProperty("业务端ID")
  @SaturnColumn(description = "业务端ID")
  private String businessId;

  /**
   * 账户安全手机号
   */
  @ApiModelProperty("账户安全手机号")
  @SaturnColumn(description = "账户安全手机号")
  private String securityMobile;

  /**
   *  saas端 客户名称
   */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称（厂商/经销商）")
  private String clientName;

  /**
   *  是否显示余额
   */
  @ApiModelProperty("是否显示余额")
  @SaturnColumn(description = "是否显示余额")
  private Boolean showBalance;

  /**
   * 微信appId
   */
  @ApiModelProperty("微信appId")
  @SaturnColumn(description = "微信appId")
  private String appId;

  /**
   * 电子账户开户信息
   */
  @ApiModelProperty("电子账户开户信息")
  @SaturnColumn(description = "电子账户开户信息")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
  private ElectronicAccountInfoDto accountInfo;

  /**
   * 电子账户证件信息
   */
  @ApiModelProperty("电子账户证件信息")
  @SaturnColumn(description = "电子账户证件信息")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
  private ElectronicAccountCertificateDto certificate;

  /**
   * 电子账户证件信息
   */
  @ApiModelProperty("电子账户证件信息")
  @SaturnColumn(description = "电子账户证件信息")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
  private Set<ElectronicAccountBankDto> banks;

  /**
   * 电子账户失败记录
   */
  @ApiModelProperty("电子账户失败记录")
  @SaturnColumn(description = "电子账户失败记录")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
  private Set<ElectronicAccountFailureRecordDto> failureRecords;

  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public Integer getApplyState() {
    return applyState;
  }

  public void setApplyState(Integer applyState) {
    this.applyState = applyState;
  }

  public String getLatestFailureReason() {
    return latestFailureReason;
  }

  public void setLatestFailureReason(String latestFailureReason) {
    this.latestFailureReason = latestFailureReason;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public Integer getTiedCardStatus() {
    return tiedCardStatus;
  }

  public void setTiedCardStatus(Integer tiedCardStatus) {
    this.tiedCardStatus = tiedCardStatus;
  }

  public Integer getAppType() {
    return appType;
  }

  public void setAppType(Integer appType) {
    this.appType = appType;
  }

  public Integer getSignerType() {
    return signerType;
  }

  public void setSignerType(Integer signerType) {
    this.signerType = signerType;
  }

  public String getSignerName() {
    return signerName;
  }

  public void setSignerName(String signerName) {
    this.signerName = signerName;
  }

  public String getSignerIdCardNo() {
    return signerIdCardNo;
  }

  public void setSignerIdCardNo(String signerIdCardNo) {
    this.signerIdCardNo = signerIdCardNo;
  }

  public String getSignerMobile() {
    return signerMobile;
  }

  public void setSignerMobile(String signerMobile) {
    this.signerMobile = signerMobile;
  }

  public String getMerchantCode() {
    return merchantCode;
  }

  public void setMerchantCode(String merchantCode) {
    this.merchantCode = merchantCode;
  }

  public String getMerchantName() {
    return merchantName;
  }

  public void setMerchantName(String merchantName) {
    this.merchantName = merchantName;
  }

  public Date getOpenTime() {
    return openTime;
  }

  public void setOpenTime(Date openTime) {
    this.openTime = openTime;
  }

  public Date getExpireTime() {
    return expireTime;
  }

  public void setExpireTime(Date expireTime) {
    this.expireTime = expireTime;
  }

  public Date getPreApplyTime() {
    return preApplyTime;
  }

  public void setPreApplyTime(Date preApplyTime) {
    this.preApplyTime = preApplyTime;
  }

  public Date getRepeatedApplyTime() {
    return repeatedApplyTime;
  }

  public void setRepeatedApplyTime(Date repeatedApplyTime) {
    this.repeatedApplyTime = repeatedApplyTime;
  }

  public Date getSignTime() {
    return signTime;
  }

  public void setSignTime(Date signTime) {
    this.signTime = signTime;
  }

  public String getBucketCode() {
    return bucketCode;
  }

  public void setBucketCode(String bucketCode) {
    this.bucketCode = bucketCode;
  }

  public ElectronicAccountInfoDto getAccountInfo() {
    return accountInfo;
  }

  public void setAccountInfo(ElectronicAccountInfoDto accountInfo) {
    this.accountInfo = accountInfo;
  }

  public ElectronicAccountCertificateDto getCertificate() {
    return certificate;
  }

  public void setCertificate(ElectronicAccountCertificateDto certificate) {
    this.certificate = certificate;
  }

  public Set<ElectronicAccountBankDto> getBanks() {
    return banks;
  }

  public void setBanks(Set<ElectronicAccountBankDto> banks) {
    this.banks = banks;
  }

  public Set<ElectronicAccountFailureRecordDto> getFailureRecords() {
    return failureRecords;
  }

  public void setFailureRecords(Set<ElectronicAccountFailureRecordDto> failureRecords) {
    this.failureRecords = failureRecords;
  }

  public String getBusinessId() {
    return businessId;
  }

  public void setBusinessId(String businessId) {
    this.businessId = businessId;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }

  public String getBillingCycle() {
    return billingCycle;
  }

  public void setBillingCycle(String billingCycle) {
    this.billingCycle = billingCycle;
  }

  public String getClientName() {
    return clientName;
  }

  public void setClientName(String clientName) {
    this.clientName = clientName;
  }

  public Boolean getShowBalance() {
    return showBalance;
  }

  public void setShowBalance(Boolean showBalance) {
    this.showBalance = showBalance;
  }

  public String getAppId() {
    return appId;
  }

  public void setAppId(String appId) {
    this.appId = appId;
  }

  public String getSecurityMobile() {
    return securityMobile;
  }

  public void setSecurityMobile(String securityMobile) {
    this.securityMobile = securityMobile;
  }
}
