package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.util.Date;

/**
 * 电子账户失败记录
 * @Author: Paul Chan
 * @Date: 2021/4/9 上午11:12
 */
@ApiModel(value = "ElectronicAccountFailureRecord", description = "电子账户失败记录")
public class ElectronicAccountFailureRecordDto extends UuidVo {

  private static final long serialVersionUID = -6777533034003772491L;
  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @SaturnColumn(description = "创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  private Date createTime;

  /**
   * 失败原因
   */
  @ApiModelProperty("失败原因")
  @SaturnColumn(description = "失败原因")
  @Column(name = "failure_reason", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '失败原因'")
  private String failureReason;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.ManyToOne)
  private ElectronicAccountDto electronicAccount;

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getFailureReason() {
    return failureReason;
  }

  public void setFailureReason(String failureReason) {
    this.failureReason = failureReason;
  }

  public ElectronicAccountDto getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccountDto electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
