package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 电子账户基本信息
 * @Author: Paul Chan
 * @Date: 2021/4/7 下午6:14
 */
@ApiModel(value = "ElectronicAccountInfo", description = "电子账户基本信息")
public class ElectronicAccountInfoDto extends UuidVo {

  private static final long serialVersionUID = -661351247594522291L;
  /**
   * 经营者姓名
   */
  @ApiModelProperty("经营者姓名")
  @SaturnColumn(description = "经营者姓名")
  private String managementName;

  /**
   * 企业名称
   */
  @ApiModelProperty("企业名称")
  @SaturnColumn(description = "企业名称")
  private String companyName;

  /**
   * 企业简称
   */
  @ApiModelProperty("企业简称")
  @SaturnColumn(description = "企业简称")
  private String companyShortName;

  /**
   * 分类类别
   * 101 储蓄客户
   * 102 内部员工
   * 103 对公联动客户
   * 199 个人－其他
   * 201 国有企业
   * 202 集体企业
   * 203 股份合作企业
   * 204 联营企业
   * 205 有限责任公司
   * 206 股份有限公司
   * 207 私营企业
   * 208 港、澳、台投资企业
   * 209 外商投资企业
   * 210 个体经营
   * 211 乡镇企业
   * 299 其他
   * 301 中国人民银行
   * 302 国家外汇管理局
   * 303 1－中国银行业监督管理委员会
   * 304 2－中国证券监督管理委员会
   * 305 3－中国保险监督管理委员会
   * 306 国家开发银行
   * 307 进出口银行
   * 308 农村发展银行
   * 309 国有独资商业银行
   * 310 其他大型商业银行
   * 311 全国性中小型商业银行
   * 312 城市商业银行
   * 313 农村商业银行
   * 314 其他商业银行
   * 315 邮储
   * 316 村镇银行
   * 317 外资银行法人
   * 318 外国银行分行
   * 319 多边开发银行
   * 320 城市信用社
   * 321 农村信用社
   * 322 农村合作银行
   * 323 农村资金互助社
   * 324 财务公司
   * 325 证券公司
   * 326 证券投资基金管理公司
   * 327 期货公司
   * 328 投资咨询公司
   * 329 基金公司
   * 330 信托公司
   * 331 金融资产管理公司(不含国有资产管理公司)
   * 332 国有资产管理公司
   * 333 金融租赁公司
   * 334 汽车金融公司
   * 335 贷款公司
   * 336 货币经纪公司
   * 337 财产保险公司
   * 338 人身保险公司
   * 339 再保险公司
   * 340 保险资产管理公司
   * 341 保险经纪公司
   * 342 保险代理公司
   * 343 保险公估公司
   * 344 企业年金
   * 345 养老及社保单位
   * 346 证券交易所
   * 347 期货交易所
   * 348 登记结算类机构
   * 349 中央金融控股公司
   * 350 其他金融控股公司
   * 351 小额贷款公司
   * 352 其他境内特殊目的载体（SPV）
   * 353 其他金融辅助机构（不含SPV）
   * 399 其他金融机构
   * 401 中央直属
   * 402 省直属
   * 403 市直属
   * 404 事业单位
   * 405 公积金单位
   * 406 公共部门实体
   * 499 其他政府机关
   * 501 小微企业
   * 601 内部客户
   * 701 社会团体
   * 702 部队
   * 703 其他
   */
  @ApiModelProperty("分类类别")
  @SaturnColumn(description = "分类类别")
  private String category;

  /**
   * 邮箱
   */
  @ApiModelProperty("邮箱")
  @SaturnColumn(description = "邮箱")
  private String email;

  /**
   * 企业地址
   */
  @ApiModelProperty("企业地址")
  @SaturnColumn(description = "企业地址")
  private String address;

  /**
   * 行业
   * 110 内资-国有全资
   * 120 内资-集体全资
   * 130 内资-股份合作
   * 141 内资-联营-国有联营
   * 142 内资-联营-集体联营
   * 143 内资-联营-国有与集体联营
   * 149 内资-联营-其他联营
   * 151 内资-有限责任（公司）-国有独资（公司）
   * 152 内资-有限责任（公司）-其他有限责任（公司）
   * 160 内资-股份有限（公司）
   * 171 内资-私有（私营）-独资
   * 172 内资-私有（私营）-合伙
   * 173 内资-私有（私营）-有限责任（公司）
   * 174 内资-私有（私营）-股份有限（公司）
   * 175 内资-个体经营
   * 176 内资-其他私有
   * 190 内资-其他内资
   * 210 港澳台投资-内地和港澳台合资
   * 220 港澳台投资-内地和港澳台合作
   * 230 港澳台投资-港澳台独资
   * 240 港澳台投资-港澳台投资股份有限（公司）
   * 250 港澳台投资-其他港澳台投资
   * 310 国外投资-中外合资
   * 320 国外投资-中外合作
   * 330 国外投资-外资独资
   * 340 国外投资-国外投资股份有限（公司）
   * 350 国外投资-其他国外投资
   * 400 个体经营
   * 410 个体经营－个体户
   * 420 个体经营－个人合伙
   * 500 国家党政机关
   * 510 事业单位
   * 600 军队
   * 700 社会团体
   * 810 境外公司-外资公司
   * 820 境外公司-中资公司
   * 830 境外公司-金融机构
   * 900 外国政府
   */
  @ApiModelProperty("行业")
  @SaturnColumn(description = "行业")
  private String industry;

  /**
   * 通用行业
   */
  @ApiModelProperty("通用行业")
  @SaturnColumn(description = "通用行业")
  private String generalIndustry;

  /**
   * 规模 1:大型,2:中性,3:小型,4:微型,5:其他
   */
  @ApiModelProperty("规模 1:大型,2:中性,3:小型,4:微型,5:其他")
  @SaturnColumn(description = "规模 1:大型,2:中性,3:小型,4:微型,5:其他")
  private String scale;

  /**
   * 开户许可证核准号
   */
  @ApiModelProperty("开户许可证核准号")
  @SaturnColumn(description = "开户许可证核准号")
  private String approvalNo;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  @SaturnColumn(description = "手机号")
  private String mobile;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @SaturnColumn(description = "省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  @SaturnColumn(description = "省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @SaturnColumn(description = "市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  @SaturnColumn(description = "市名称")
  private String cityName;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  @SaturnColumn(description = "区编码")
  private String districtCode;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  @SaturnColumn(description = "区名称")
  private String districtName;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
  private ElectronicAccountDto electronicAccount;

  public String getManagementName() {
    return managementName;
  }

  public void setManagementName(String managementName) {
    this.managementName = managementName;
  }

  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  public String getCompanyShortName() {
    return companyShortName;
  }

  public void setCompanyShortName(String companyShortName) {
    this.companyShortName = companyShortName;
  }

  public String getCategory() {
    return category;
  }

  public void setCategory(String category) {
    this.category = category;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public String getIndustry() {
    return industry;
  }

  public void setIndustry(String industry) {
    this.industry = industry;
  }

  public String getGeneralIndustry() {
    return generalIndustry;
  }

  public void setGeneralIndustry(String generalIndustry) {
    this.generalIndustry = generalIndustry;
  }

  public String getScale() {
    return scale;
  }

  public void setScale(String scale) {
    this.scale = scale;
  }

  public String getApprovalNo() {
    return approvalNo;
  }

  public void setApprovalNo(String approvalNo) {
    this.approvalNo = approvalNo;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getProvinceCode() {
    return provinceCode;
  }

  public void setProvinceCode(String provinceCode) {
    this.provinceCode = provinceCode;
  }

  public String getProvinceName() {
    return provinceName;
  }

  public void setProvinceName(String provinceName) {
    this.provinceName = provinceName;
  }

  public String getCityCode() {
    return cityCode;
  }

  public void setCityCode(String cityCode) {
    this.cityCode = cityCode;
  }

  public String getCityName() {
    return cityName;
  }

  public void setCityName(String cityName) {
    this.cityName = cityName;
  }

  public String getDistrictCode() {
    return districtCode;
  }

  public void setDistrictCode(String districtCode) {
    this.districtCode = districtCode;
  }

  public String getDistrictName() {
    return districtName;
  }

  public void setDistrictName(String districtName) {
    this.districtName = districtName;
  }

  public ElectronicAccountDto getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccountDto electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
