package com.bizunited.empower.business.payment.dto;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 提现Dto
 *
 * @author Keller
 */
public class ExtractCashDto implements Serializable {
  private static final long serialVersionUID = -9163875592615538261L;
  /**
   * 提现金额（单位：分）
   */
  private String amount;
  /**
   * 到账类型 10=T+1 20=D0
   */
  private String arrivalType;
  /**
   * 备注
   */
  private String remark;
  /**
   * 租户编号
   */
  @NotBlank(message = "租户编号不能为空")
  private String tenantCode;
  /**
   * 提现用户类型 1、saas平台 2、品牌商 3、经销商
   */
  private Integer userType;

  public String getAmount() {
    return amount;
  }

  public void setAmount(String amount) {
    this.amount = amount;
  }

  public String getArrivalType() {
    return arrivalType;
  }

  public void setArrivalType(String arrivalType) {
    this.arrivalType = arrivalType;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public Integer getUserType() {
    return userType;
  }

  public void setUserType(Integer userType) {
    this.userType = userType;
  }
}
