package com.bizunited.empower.business.payment.dto;

import io.swagger.annotations.ApiModel;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 支付dto
 *
 * @author Keller
 */
@ApiModel(value = "PayDto", description = "支付相关参数")
public class PayDto implements Serializable {

  private static final long serialVersionUID = 6004082106658208525L;
  /**
   * 订单号
   */
  @NotBlank(message = "订单编号不能为空")
  private String orderNo;
  /**
   * 付款用户 ID
   */
  @NotBlank(message = "付款用户 ID不能为空")
  private String payerUserId;
  /**
   * 付款用户 ID
   */
  @NotBlank(message = "付款用户名称不能为空")
  private String payerUserName;
  /**
   * 收款用户 ID
   */
  @NotBlank(message = "收款用户 ID不能为空")
  private String payeeUserId;
  /**
   * 收款用户帐号 空就行
   */
  private String payeeAccountNumber;
  /**
   * 支付方式
   */
  private String paymentWay;
  /**
   * 支付金额 单位:分,
   */
  @NotBlank(message = "支付金额不能为空")
  private String amount;
  /**
   * 交易失效时间 单位:分钟 扫码支付默认为 24小时
   */
  private String expirePeriod;
  /**
   * 商品名称
   */
  @NotBlank(message = "商品名称不能为空")
  private String goodsName;
  /**
   * 是否有后续分账 默认为否 1-否 2-是
   */
  private String hasSubsequentSplit = "1";
  /**
   * 支付方式 45=H5 支付 (PayType=30、 31、32、33) 46=APP 支付 (PayType=30、 31、32、33)
   * 47=手机迷你付 (PayType=33) 48=手机 Pay (PayType=34、 35) 50=JSAPI (PayType=31、 32) 51=小程序支付 (PayType=31)
   */
  private String payWay;
  /**
   * 支付类型 30=手机网银 31=微信 32=支付宝 33=银联 34=Apple Pay 35=Android Pay
   */
  private String payType;
  /**
   * 跳转前来源: 10=App 20=H5 30=公众号 40=小程序
   */
  private String redirectSource;
  /**
   * 商户进件录入
   */
  private String subAppID;
  /**
   * 小程序openid
   */
  private String subOpenID;
  /**
   * 客户地址
   */
  private String clientIP;
  /**
   * 条码支付类型: 10=微信 20=支付宝 30=银联 40=聚合码
   */
  private String scanPaymentType;
  /**
   * 条码支付方式: 41=正扫 42=反扫
   */
  private String scanPaymentWay;
  /**
   * 备注
   */
  private String remark;
  /**
   * 租户编号
   */
  @NotBlank(message = "租户编号不能为空")
  private String tenantCode;

  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  public String getPayerUserId() {
    return payerUserId;
  }

  public void setPayerUserId(String payerUserId) {
    this.payerUserId = payerUserId;
  }

  public String getPayerUserName() {
    return payerUserName;
  }

  public void setPayerUserName(String payerUserName) {
    this.payerUserName = payerUserName;
  }

  public String getPayeeUserId() {
    return payeeUserId;
  }

  public void setPayeeUserId(String payeeUserId) {
    this.payeeUserId = payeeUserId;
  }

  public String getPayeeAccountNumber() {
    return payeeAccountNumber;
  }

  public void setPayeeAccountNumber(String payeeAccountNumber) {
    this.payeeAccountNumber = payeeAccountNumber;
  }

  public String getPaymentWay() {
    return paymentWay;
  }

  public void setPaymentWay(String paymentWay) {
    this.paymentWay = paymentWay;
  }

  public String getAmount() {
    return amount;
  }

  public void setAmount(String amount) {
    this.amount = amount;
  }

  public String getExpirePeriod() {
    return expirePeriod;
  }

  public void setExpirePeriod(String expirePeriod) {
    this.expirePeriod = expirePeriod;
  }

  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  public String getHasSubsequentSplit() {
    return hasSubsequentSplit;
  }

  public void setHasSubsequentSplit(String hasSubsequentSplit) {
    this.hasSubsequentSplit = hasSubsequentSplit;
  }

  public String getPayWay() {
    return payWay;
  }

  public void setPayWay(String payWay) {
    this.payWay = payWay;
  }

  public String getPayType() {
    return payType;
  }

  public void setPayType(String payType) {
    this.payType = payType;
  }

  public String getRedirectSource() {
    return redirectSource;
  }

  public void setRedirectSource(String redirectSource) {
    this.redirectSource = redirectSource;
  }

  public String getSubAppID() {
    return subAppID;
  }

  public void setSubAppID(String subAppID) {
    this.subAppID = subAppID;
  }

  public String getSubOpenID() {
    return subOpenID;
  }

  public void setSubOpenID(String subOpenID) {
    this.subOpenID = subOpenID;
  }

  public String getClientIP() {
    return clientIP;
  }

  public void setClientIP(String clientIP) {
    this.clientIP = clientIP;
  }

  public String getScanPaymentType() {
    return scanPaymentType;
  }

  public void setScanPaymentType(String scanPaymentType) {
    this.scanPaymentType = scanPaymentType;
  }

  public String getScanPaymentWay() {
    return scanPaymentWay;
  }

  public void setScanPaymentWay(String scanPaymentWay) {
    this.scanPaymentWay = scanPaymentWay;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
}
