package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 支付通知数据传输dto
 * @author Keller
 */
public class PayNoticeDto implements Serializable {
  private static final long serialVersionUID = -252381366958632792L;
  /**
   * 由SaaS平台确认的，为该新的租户服务的资源桶的唯一编号,
   */
  @ApiModelProperty("资源桶的唯一编号")
  @SaturnColumn(description = "资源桶的唯一编号")
  private String bucketCode;
  /**
   * 状态 1、处理中（不发通知） 2、支付成功（通知） 3、支付失败（通知）
   */
  private Integer status;
  /**
   * 订单编号(应收单号)
   */
  private String orderNo;
  /**
   * 流水号
   */
  private String txSN;
  /**
   * 租户编号
   */
  private String tenantCode;
  /**
   * 品牌商编号
   */
  private String appCode;
  /**
   * 金额
   */
  private BigDecimal amount;
  /**
   * 费率
   */
  private BigDecimal feeRate;
  /**
   * 手续费
   */
  private BigDecimal fee;
  /**
   * 实际金额
   */
  private BigDecimal realAmount;
  /**
   * 备注
   */
  private String remark;

  public String getBucketCode() {
    return bucketCode;
  }

  public void setBucketCode(String bucketCode) {
    this.bucketCode = bucketCode;
  }

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  public String getTxSN() {
    return txSN;
  }

  public void setTxSN(String txSN) {
    this.txSN = txSN;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public BigDecimal getFeeRate() {
    return feeRate;
  }

  public void setFeeRate(BigDecimal feeRate) {
    this.feeRate = feeRate;
  }

  public BigDecimal getFee() {
    return fee;
  }

  public void setFee(BigDecimal fee) {
    this.fee = fee;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public BigDecimal getRealAmount() {
    return realAmount;
  }

  public void setRealAmount(BigDecimal realAmount) {
    this.realAmount = realAmount;
  }
}
