package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 收款单附件参数
 *
 * @author Keller
 */
@ApiModel(value = "ReceiptAttachmentDto", description = "收款单附件参数")
public class ReceiptAttachmentDto implements Serializable {
  private static final long serialVersionUID = 3466579125954387283L;
  /**
   * 相对路径
   */
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;
  /**
   * 原始文件名
   */
  @SaturnColumn(description = "原始文件名")
  @ApiModelProperty("原始文件名")
  private String fileName;
  /**
   * 重命名后的文件名
   */
  @SaturnColumn(description = "重命名后的文件名")
  @ApiModelProperty("重命名后的文件名")
  private String reFileName;

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getReFileName() {
    return reFileName;
  }

  public void setReFileName(String reFileName) {
    this.reFileName = reFileName;
  }
}
