package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 收款单参数 dto
 *
 * @author Keller
 */
@ApiModel(value = "ReceiptDto", description = "收款相关单位")
public class ReceiptDto implements Serializable {
  private static final long serialVersionUID = -836914824746748L;
  /**
   * 关联单据号
   */
  @ApiModelProperty(name = "associatedCode", value = "关联单据号")
  private String associatedCode;
  /**
   * 金额
   */
  @ApiModelProperty(name = "receiptAmount", value = "金额")
  private BigDecimal receiptAmount;
  /**
   * 资金渠道类型
   */
  @ApiModelProperty(name = "fundsChannel", value = "资金渠道类型")
  private Integer fundsChannel;
  /**
   * 收款时间
   */
  @ApiModelProperty(name = "receiptTime", value = "收款时间")
  private Date receiptTime;
  /**
   * 备注
   */
  @ApiModelProperty(name = "remark", value = "备注")
  private String remark;
  /**
   * 收款单附件
   */
  @SaturnColumn(description = "收款单附件")
  @ApiModelProperty("收款单附件")
  private Set<ReceiptAttachmentDto> receiptAttachments;

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public Integer getFundsChannel() {
    return fundsChannel;
  }

  public void setFundsChannel(Integer fundsChannel) {
    this.fundsChannel = fundsChannel;
  }

  public Date getReceiptTime() {
    return receiptTime;
  }

  public void setReceiptTime(Date receiptTime) {
    this.receiptTime = receiptTime;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<ReceiptAttachmentDto> getReceiptAttachments() {
    return receiptAttachments;
  }

  public void setReceiptAttachments(Set<ReceiptAttachmentDto> receiptAttachments) {
    this.receiptAttachments = receiptAttachments;
  }

  public BigDecimal getReceiptAmount() {
    return receiptAmount;
  }

  public void setReceiptAmount(BigDecimal receiptAmount) {
    this.receiptAmount = receiptAmount;
  }
}
