package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 退款通知数据传输dto
 * @author Keller
 */
public class RefundNoticeDto implements Serializable {
  private static final long serialVersionUID = 1109823907027117297L;
  /**
   * 由SaaS平台确认的，为该新的租户服务的资源桶的唯一编号,
   */
  @ApiModelProperty("资源桶的唯一编号")
  @SaturnColumn(description = "资源桶的唯一编号")
  private String bucketCode;
  /**
   * 状态 1、处理中（不发通知） 2、支付成功（通知） 3、支付失败（通知）
   */
  private Integer status;
  /**
   * 流水号
   */
  private String txSN;
  /**
   * 经销商编码
   */
  private String tenantCode;
  /**
   * 厂商编号
   */
  private String appCode;

  public String getBucketCode() {
    return bucketCode;
  }

  public void setBucketCode(String bucketCode) {
    this.bucketCode = bucketCode;
  }

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public String getTxSN() {
    return txSN;
  }

  public void setTxSN(String txSN) {
    this.txSN = txSN;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
}
