package com.bizunited.empower.business.payment.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * SignDto
 *
 * @Author: Paul Chan
 * @Date: 2021/4/15 17:05
 */
@ApiModel(value = "SignDto", description = "签约传参")
public class SignDto implements Serializable {
  private static final long serialVersionUID = 437511755043285300L;
  /** saas端 电子账户ID   */
  @ApiModelProperty("电子账户ID")
  private String accountId;

  /** saas端 业务端ID   */
  @ApiModelProperty("业务端ID")
  private String businessId;

  /** 厂商编号/经销商编号    */
  @ApiModelProperty(name = "tenantCode", value = "厂商编号/经销商编号", required = true)
  private String tenantCode;

  /** 验证码  */
  @ApiModelProperty(name = "verifyCode", value = "验证码")
  private String verifyCode;

  /** true：要修改  */
  @ApiModelProperty(name = "isUpdate", value = "是否修改")
  private Boolean isUpdate;

  /** 名字  */
  @ApiModelProperty(name = "name", value = "名字")
  private String name;

  /** 身份证  */
  @ApiModelProperty(name = "idCardNo", value = "身份证")
  private String idCardNo;

  /** 手机  */
  @ApiModelProperty(name = "mobile", value = "手机")
  private String mobile;

  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public String getBusinessId() {
    return businessId;
  }

  public void setBusinessId(String businessId) {
    this.businessId = businessId;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getVerifyCode() {
    return verifyCode;
  }

  public void setVerifyCode(String verifyCode) {
    this.verifyCode = verifyCode;
  }

  public Boolean getIsUpdate() {
    return isUpdate;
  }

  public void setIsUpdate(Boolean update) {
    isUpdate = update;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getIdCardNo() {
    return idCardNo;
  }

  public void setIdCardNo(String idCardNo) {
    this.idCardNo = idCardNo;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }
}
