package com.bizunited.empower.business.payment.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * TenantElectronicAccountDto 平台外电子账户必传参数
 *
 * @Author: hefan
 * @Date: 2021/4/15 17:05
 */
@ApiModel(value = "TenantElectronicAccountDto", description = "平台外电子账户必传参数")
public class TenantElectronicAccountDto implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 8718017431087943039L;

  /** saas端 业务端ID   */
  @ApiModelProperty("业务端ID")
  private String businessId;

  /** 厂商编号/经销商编号    */
  @ApiModelProperty(name = "tenantCode", value = "厂商编号/经销商编号", required = true)
  private String tenantCode;

  public String getBusinessId() {
    return businessId;
  }

  public void setBusinessId(String businessId) {
    this.businessId = businessId;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
}
