package com.bizunited.empower.business.payment.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * TiedCardVerifyDto
 *
 * @Author: hefan
 * @Date: 2021/4/15 17:05
 */
@ApiModel(value = "TiedCardVerifyDto", description = "绑卡确认传参")
public class TiedCardVerifyDto implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 6573264623695785578L;

  /** saas端 电子账户ID   */
  @ApiModelProperty("电子账户ID")
  private String accountId;

  /** saas端 业务端ID   */
  @ApiModelProperty("业务端ID")
  private String businessId;

  /** saas端 收款金额   */
  @ApiModelProperty("收款金额")
  private String amountReceived;

  /** saas端 短信验证码   */
  @ApiModelProperty("短信验证码")
  private String smsCode;

  /** 厂商编号/经销商编号    */
  @ApiModelProperty(name = "tenantCode", value = "厂商编号/经销商编号", required = true)
  private String tenantCode;

  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public String getBusinessId() {
    return businessId;
  }

  public void setBusinessId(String businessId) {
    this.businessId = businessId;
  }

  public String getAmountReceived() {
    return amountReceived;
  }

  public void setAmountReceived(String amountReceived) {
    this.amountReceived = amountReceived;
  }

  public String getSmsCode() {
    return smsCode;
  }

  public void setSmsCode(String smsCode) {
    this.smsCode = smsCode;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
}
