package com.bizunited.empower.business.payment.dto;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 转账通知传参
 *
 * @author Keller
 */
public class TransferNoticeDto implements Serializable {
  private static final long serialVersionUID = -6268453837376934405L;
  /**
   * 由SaaS平台确认的，为该新的租户服务的资源桶的唯一编号,
   */
  @ApiModelProperty("资源桶的唯一编号")
  @SaturnColumn(description = "资源桶的唯一编号")
  private String bucketCode;
  /**
   * 品牌商编号
   */
  private String appCode;
  /**
   * 经销商租户编号
   */
  private String tenantCode;
  /**
   * 客户编号
   */
  private String customerCode;
  /**
   * 金额
   */
  private BigDecimal amount;
  /**
   * 银行卡号
   */
  private String cardNum;

  /**
   * 业务类型 1、提现 2、线下转账
   */
  private Integer businessType;
  /**
   * 流水号
   */
  private String txSN;
  /**
   * 状态 1、待处理 2、成功 3、失败
   */
  private Integer status;

  public String getBucketCode() {
    return bucketCode;
  }

  public void setBucketCode(String bucketCode) {
    this.bucketCode = bucketCode;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public String getCardNum() {
    return cardNum;
  }

  public void setCardNum(String cardNum) {
    this.cardNum = cardNum;
  }

  public Integer getBusinessType() {
    return businessType;
  }

  public void setBusinessType(Integer businessType) {
    this.businessType = businessType;
  }

  public String getTxSN() {
    return txSN;
  }

  public void setTxSN(String txSN) {
    this.txSN = txSN;
  }

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }
}
