package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 客户银行账号信息
 *
 * @author Keller
 */
@Entity
@Table(name="`customer_bank`")
@ApiModel(value = "CustomerBank", description = "客户银行账号")
@org.hibernate.annotations.Table(appliesTo = "`customer_bank`", comment = "客户银行账号")
public class CustomerBank extends TenantEntity {

  private static final long serialVersionUID = -8775255827893047642L;
  /** 客户信息 */
  @ApiModelProperty("客户信息")
  @SaturnColumn(description = "客户信息")
  @Column(name = "customer_code", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户编码 '")
  private String customerCode;
  /**
   * 持卡人
   */
  @ApiModelProperty("持卡人")
  @SaturnColumn(description = "持卡人")
  @Column(name = "card_holder", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 持卡人 '")
  private String cardHolder;
  /**
   * 卡号
   */
  @ApiModelProperty("卡号")
  @SaturnColumn(description = "卡号")
  @Column(name = "card_number", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 卡号 '")
  private String cardNumber;
  /**
   * 卡类型: 10=借记卡 20=贷记卡
   */
  @ApiModelProperty("卡类型: 10=借记卡 20=贷记卡 ")
  @SaturnColumn(description = "卡类型: 10=借记卡 20=贷记卡")
  @Column(name = "card_type", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 卡类卡类型: 10=借记卡 20=贷记卡型 '")
  private String cardType;
  /**
   * 开户行名称
   */
  @ApiModelProperty("开户行名称")
  @SaturnColumn(description = "开户行名称")
  @Column(name = "bank_name", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 开户行名称 '")
  private String bankName;
  /**
   * 开户行
   */
  @ApiModelProperty("开户行")
  @SaturnColumn(description = "开户行")
  @Column(name = "bank_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 开户行 '")
  private String bankId;
  /**
   * 状态： 正常:1、删除:0
   */
  @Column(name = "tstatus", nullable = false, columnDefinition = "INT COMMENT '状态： 正常:1、删除:0'")
  @SaturnColumn(description = "状态： 正常:1、删除:0")
  @ApiModelProperty("状态： 正常:1、删除:0")
  private Integer tstatus;
  /**
   * 创建时间
   * */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后更新时间
   *  */
  @ApiModelProperty(name = "modifyTime", value = "最后更新时间", required = true)
  @Column(name = "modify_time" , columnDefinition = "datetime COMMENT '最后更新时间'")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyTime;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCardHolder() {
    return cardHolder;
  }

  public void setCardHolder(String cardHolder) {
    this.cardHolder = cardHolder;
  }

  public String getCardNumber() {
    return cardNumber;
  }

  public void setCardNumber(String cardNumber) {
    this.cardNumber = cardNumber;
  }

  public String getCardType() {
    return cardType;
  }

  public void setCardType(String cardType) {
    this.cardType = cardType;
  }

  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  public String getBankId() {
    return bankId;
  }

  public void setBankId(String bankId) {
    this.bankId = bankId;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
