package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Set;

/**
 * 客户信用
 *
 * 金额的数据类型为整型，单位都为厘
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午9:40
 */
@Entity
@Table(name="`customer_credit`" ,
    indexes = {@Index(columnList = "tenant_code,customer_code", unique = true)})
@ApiModel(value = "CustomerCredit", description = "客户信用")
@org.hibernate.annotations.Table(appliesTo = "`customer_credit`", comment = "客户信用")
public class CustomerCredit extends TenantOpEntity {
  private static final long serialVersionUID = -8132745930086761821L;

  /** 客户信息 */
  @ApiModelProperty("客户信息")
  @SaturnColumn(description = "客户信息")
  @Column(name = "customer_code", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户编码 '")
  private String customerCode;

  /**
   * 总额度
   */
  @Column(name = "total_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 总额度 '")
  @SaturnColumn(description = "总额度")
  @ApiModelProperty("总额度")
  private BigDecimal totalAmount;

  /**
   * 已用额度
   */
  @Column(name = "used_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 已用额度 '")
  @SaturnColumn(description = "已用额度")
  @ApiModelProperty("已用额度")
  private BigDecimal usedAmount;

  /**
   * 剩余额度
   */
  @Column(name = "balance", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 剩余额度 '")
  @SaturnColumn(description = "剩余额度")
  @ApiModelProperty("剩余额度")
  private BigDecimal balance;

  /**
   * 用户信用状态： 正常:1、禁用:0
   */
  @Column(name = "tstatus", nullable = false, columnDefinition = "INT COMMENT '用户信用状态： 正常:1、禁用:0'")
  @SaturnColumn(description = "用户信用状态： 正常:1、禁用:0")
  @ApiModelProperty("用户信用状态： 正常:1、禁用:0")
  private Integer tstatus;

  /**
   * 客户信用流水账单
   */
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "customerCredit")
  @SaturnColumn(description = "客户信用流水账单")
  @ApiModelProperty("客户信用流水账单")
  @OrderBy("createTime desc")
  private Set<CustomerCreditBill> customerCreditBills;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public Set<CustomerCreditBill> getCustomerCreditBills() {
    return customerCreditBills;
  }

  public void setCustomerCreditBills(Set<CustomerCreditBill> customerCreditBills) {
    this.customerCreditBills = customerCreditBills;
  }

  public BigDecimal getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }

  public BigDecimal getUsedAmount() {
    return usedAmount;
  }

  public void setUsedAmount(BigDecimal usedAmount) {
    this.usedAmount = usedAmount;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
}
