package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 客户信用流水账单
 * 记录客户信用的使用情况
 *
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:20
 */
@Entity
@Table(name="`customer_credit_bill`", indexes = {@Index(columnList = "tenant_code , bill_no", unique = true),
                                                 @Index(columnList = "tenant_code , business_no", unique = true)})
@ApiModel(value = "CustomerCreditBill", description = "客户信用流水账单")
@org.hibernate.annotations.Table(appliesTo = "`customer_credit_bill`", comment = "客户信用流水账单")
public class CustomerCreditBill extends TenantEntity {
  private static final long serialVersionUID = -3656013341424723804L;

  /**
   * 流水单号
   */
  @Column(name = "bill_no", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 流水单号 '")
  @SaturnColumn(description = "流水单号")
  @ApiModelProperty("流水单号")
  private String billNo;

  /**
   * 业务单号
   */
  @Column(name = "business_no", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 业务单号 '")
  @SaturnColumn(description = "业务单号")
  @ApiModelProperty("业务单号")
  private String businessNo;

  /**
   * 变更额度
   */
  @Column(name = "amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 变更额度 '")
  @SaturnColumn(description = "变更额度")
  @ApiModelProperty("变更额度")
  private BigDecimal amount;

  /**
   * 剩余额度
   */
  @Column(name = "balance", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 剩余额度 '")
  @SaturnColumn(description = "剩余额度")
  @ApiModelProperty("剩余额度")
  private BigDecimal balance;

  /**
   * 操作类型，具体枚举见：com.bizunited.empower.business.customer.common.enums.CustomerCreditBillType
   */
  @Column(name = "type", nullable = false, columnDefinition = "INT(11) COMMENT ' 操作类型，1：收款 2：恢复额度 '")
  @SaturnColumn(description = "操作类型，1：收款 2：恢复额度")
  @ApiModelProperty("操作类型，1：收款 2：恢复额度")
  private Integer type;

  /**
   * 备注
   */
  @Column(name = "remark", columnDefinition = "VARCHAR(255) COMMENT ' 备注 '")
  @SaturnColumn(description = "备注")
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 创建时间
   * */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  /**
   * 最后更新时间
   *  */
  @ApiModelProperty(name = "modifyTime", value = "最后更新时间", required = true)
  @Column(name = "modify_time" , columnDefinition = "datetime COMMENT '最后更新时间'")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyTime;


  /** 客户信用 */
  @ApiModelProperty("客户信用")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "客户信用")
  @JoinColumn(name = "customer_credit_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户信用ID '")
  private CustomerCredit customerCredit;


  public CustomerCredit getCustomerCredit() {
    return customerCredit;
  }

  public void setCustomerCredit(CustomerCredit customerCredit) {
    this.customerCredit = customerCredit;
  }

  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
