package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 客户信用总额度变化记录
 *
 * 用于记录客户的信用总额度变化
 *
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:11
 */
@Entity
@Table(name="`customer_credit_record`")
@ApiModel(value = "CustomerCreditRecord", description = "客户信用总额度变化记录")
@org.hibernate.annotations.Table(appliesTo = "`customer_credit_record`", comment = "客户信用总额度变化记录")
public class CustomerCreditRecord extends UuidOpEntity {
  private static final long serialVersionUID = 1116261349691538067L;


  /** 客户信用 */
  @ApiModelProperty("客户信用")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "客户信用")
  @JoinColumn(name = "customer_credit_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户信用ID '")
  private CustomerCredit customerCredit;

  /**
   * 更改额度
   */
  @Column(name = "amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 更改额度 '")
  @SaturnColumn(description = "更改额度")
  @ApiModelProperty("更改额度")
  private BigDecimal amount;

  /**
   * 更改前额度
   */
  @Column(name = "before_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 更改前额度 '")
  @SaturnColumn(description = "更改前额度")
  @ApiModelProperty("更改前额度")
  private BigDecimal beforeAmount;

  /**
   * 更改后额度
   */
  @Column(name = "after_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 更改后额度 '")
  @SaturnColumn(description = "更改后额度")
  @ApiModelProperty("更改后额度")
  private BigDecimal afterAmount;

  /**
   * 备注
   */
  @Column(name = "remark", columnDefinition = "VARCHAR(255) COMMENT ' 备注 '")
  @SaturnColumn(description = "备注")
  @ApiModelProperty("备注")
  private String remark;

  public CustomerCredit getCustomerCredit() {
    return customerCredit;
  }

  public void setCustomerCredit(CustomerCredit customerCredit) {
    this.customerCredit = customerCredit;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public BigDecimal getBeforeAmount() {
    return beforeAmount;
  }

  public void setBeforeAmount(BigDecimal beforeAmount) {
    this.beforeAmount = beforeAmount;
  }

  public BigDecimal getAfterAmount() {
    return afterAmount;
  }

  public void setAfterAmount(BigDecimal afterAmount) {
    this.afterAmount = afterAmount;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }
}
