package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Set;

/**
 * 客户电子钱包实体
 * @Author: Paul Chan
 * @Date: 2021/4/12 下午3:06
 */
@Entity
@Table(name="`customer_wallet`" ,
    indexes = {@Index(columnList = "tenant_code , customer_code", unique = true)})
@ApiModel(value = "CustomerWallet", description = "客户电子钱包实体")
@org.hibernate.annotations.Table(appliesTo = "`customer_wallet`", comment = "客户电子钱包实体")
public class CustomerWallet extends TenantOpEntity {
  private static final long serialVersionUID = 3372534983491681647L;

  /** 客户编码 */
  @ApiModelProperty("客户编码")
  @SaturnColumn(description = "客户编码")
  @Column(name = "customer_code", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户编码 '")
  private String customerCode;

  /** 客户名称 */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  @Column(name = "customer_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户名称 '")
  private String customerName;

  /**
   * 余额
   */
  @Column(name = "balance", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 余额 '")
  @SaturnColumn(description = "余额")
  @ApiModelProperty("余额")
  private BigDecimal balance;

  /**
   * 状态：0：已禁用，1：已启用
   */
  @ApiModelProperty("状态：0：已禁用，1：已启用")
  @SaturnColumn(description = "状态：0：已禁用，1：已启用")
  @Column(name = "state", nullable = false, columnDefinition = "INT(11) COMMENT '状态：0：已禁用，1：已启用'")
  private Integer state;

  /**
   * 流水信息
   */
  @OrderBy("createTime asc")
  @ApiModelProperty(value = "流水信息")
  @SaturnColumn(description = "流水信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "wallet")
  private Set<CustomerWalletBill> bills;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public Set<CustomerWalletBill> getBills() {
    return bills;
  }

  public void setBills(Set<CustomerWalletBill> bills) {
    this.bills = bills;
  }
}
