package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 客户电子钱包流水实体
 * @Author: Paul Chan
 * @Date: 2021/4/12 下午3:25
 */
@Entity
@Table(name="`customer_wallet_bill`")
@ApiModel(value = "CustomerWalletBill", description = "客户电子钱包流水实体")
@org.hibernate.annotations.Table(appliesTo = "`customer_wallet_bill`", comment = "客户电子钱包流水实体")
public class CustomerWalletBill extends UuidEntity {
  private static final long serialVersionUID = 2414218710669904506L;

  /**
   * 操作类型，1：收款 2：恢复余额
   */
  @Column(name = "type", nullable = false, columnDefinition = "INT(11) COMMENT ' 操作类型，1：收款 2：恢复余额 '")
  @SaturnColumn(description = "操作类型，1：收款 2：恢复余额")
  @ApiModelProperty("操作类型，1：收款 2：恢复余额")
  private Integer type;

  /**
   * 流水单号
   */
  @Column(name = "bill_no", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 流水单号 '")
  @SaturnColumn(description = "流水单号")
  @ApiModelProperty("流水单号")
  private String billNo;

  /**
   * 业务类型，1：提现、2：充值、3：转账结余、4：退货退款、5：应付单
   */
  @Column(name = "business_type", nullable = false, columnDefinition = "INT(11) COMMENT ' 业务类型，1：提现、2：充值、3：转账结余、4：退货退款、5：应付单 '")
  @SaturnColumn(description = "业务类型，1：提现、2：充值、3：转账结余、4：退货退款、5：应付单")
  @ApiModelProperty("业务类型，1：提现、2：充值、3：转账结余、4：退货退款、5：应付单")
  private Integer businessType;

  /**
   * 业务单号
   */
  @Column(name = "business_no", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 业务单号 '")
  @SaturnColumn(description = "业务单号")
  @ApiModelProperty("业务单号")
  private String businessNo;

  /**
   * 变更额度
   */
  @Column(name = "amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 变更额度 '")
  @SaturnColumn(description = "变更额度")
  @ApiModelProperty("变更额度")
  private BigDecimal amount;

  /**
   * 剩余额度
   */
  @Column(name = "balance", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 剩余额度 '")
  @SaturnColumn(description = "剩余额度")
  @ApiModelProperty("剩余额度")
  private BigDecimal balance;

  /**
   * 备注
   */
  @Column(name = "remark", columnDefinition = "VARCHAR(255) COMMENT ' 备注 '")
  @SaturnColumn(description = "备注")
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", value = "创建人账号", required = false)
  @SaturnColumn(description = "创建人账号")
  @Column(name = "create_account", nullable = true, columnDefinition = "varchar(255) COMMENT '创建人账号'")
  private String createAccount;

  /**
   * 创建时间
   * */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  /**
   * 电子钱包
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "创建时间")
  @ApiModelProperty(value = "电子钱包", required = true)
  @JoinColumn(name = "wallet_id", nullable = false, columnDefinition = "varchar(255) COMMENT '电子钱包'")
  private CustomerWallet wallet;

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  public Integer getBusinessType() {
    return businessType;
  }

  public void setBusinessType(Integer businessType) {
    this.businessType = businessType;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getCreateAccount() {
    return createAccount;
  }

  public void setCreateAccount(String createAccount) {
    this.createAccount = createAccount;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public CustomerWallet getWallet() {
    return wallet;
  }

  public void setWallet(CustomerWallet wallet) {
    this.wallet = wallet;
  }
}
