package com.bizunited.empower.business.payment.entity;

import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 应付单
 * @author keller
 */
@ApiModel(value = "DefrayInfo", description = "应付单")
@Entity
@Table(name = "`defray_info`", indexes = {@Index(columnList = "tenant_code , defray_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "`defray_info`", comment = "应付单")
@BuildCustomRepository
public class DefrayInfo extends TenantOpEntity {
  /**
   *
   */
  private static final long serialVersionUID = -4619408660976584654L;
  /**
   * 付款单流水编号
   */
  @Column(name = "defray_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 付款单流水编号 '")
  @SaturnColumn(description = "付款单流水编号")
  @ApiModelProperty("付款单流水编号")
  private String defrayCode;
  /**
   * 应付账款客户编号
   */
  @Column(name = "customer_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户编号 '")
  @SaturnColumn(description = "客户编号")
  @ApiModelProperty("客户编号")
  private String customerCode;
  /**
   * 付款金额
   */
  @Column(name = "defray_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '付款金额'")
  @SaturnColumn(description = "付款金额")
  @ApiModelProperty(name = "付款金额", required = true)
  private BigDecimal defrayAmount;
  /**
   * 付款单状态 待确认:1、已确认:2、已取消:0
   */
  @Column(name = "defray_status", nullable = false, columnDefinition = "INT COMMENT '付款单状态：待确认:1、已确认:2、已取消:0'")
  @SaturnColumn(description = "付款单状态")
  @ApiModelProperty(name = "付款单状态：待确认:1、已确认:2、已取消:0", required = true)
  private Integer defrayStatus;
  /**
   * 资金渠道 {@link FundsChannelType}
   */
  @Column(name = "funds_channel", nullable = false, columnDefinition = "INT COMMENT '资金渠道 支付宝:1、微信支付:2、聚合支付:3、现金支付:4、 银行转账:5、 信用支付:6'")
  @SaturnColumn(description = "资金渠道 支付宝:1、微信支付:2、聚合支付:3、现金支付:4、 银行转账:5、 信用支付:6")
  @ApiModelProperty(name = "资金渠道 支付宝:1、微信支付:2、银联支付:3、聚合支付:4、 银行转账:5、 信用支付:6", required = true)
  private Integer fundsChannel;
  /**
   * 备注信息
   */
  @SaturnColumn(description = "备注信息")
  @ApiModelProperty("备注信息")
  @Column(name = "remark", nullable = true, columnDefinition = "VARCHAR(2000) COMMENT ' 备注信息 '")
  private String remark;
  /**
   * 付款时间
   */
  @ApiModelProperty(name = "defrayTime", value = "付款时间", required = true)
  @Column(name = "defray_time", columnDefinition = "datetime COMMENT '付款时间'")
  @SaturnColumn(description = "付款时间")
  private Date defrayTime;

  /**
   * 付款电子账户
   */
  @JoinColumn(name = "electronic_account_id", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 付款电子账户 '")
  @SaturnColumn(description = "付款电子账户")
  @ApiModelProperty("付款电子账户")
  @ManyToOne(fetch = FetchType.LAZY)
  private ElectronicAccount electronicAccount;

  /**
   * 付款账户
   */
  @JoinColumn(name = "pay_account", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 付款账户 '")
  @SaturnColumn(description = "付款账户")
  @ApiModelProperty("付款账户")
  @ManyToOne(fetch = FetchType.LAZY)
  private FundsAccount fundsAccount;

  /**
   * 应付账款编号
   */
  @SaturnColumn(description = "应付账款")
  @ApiModelProperty("应付账款编号")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "payment_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 应付账款编号 '")
  private PaymentInfo paymentInfo;

  /**
   * 付款单附件
   */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "defrayInfo")
  @SaturnColumn(description = "付款单附件")
  @ApiModelProperty("付款单附件")
  private Set<DefrayAttachment> defrayAttachments;
  public String getDefrayCode() {
    return defrayCode;
  }

  public void setDefrayCode(String defrayCode) {
    this.defrayCode = defrayCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getDefrayAmount() {
    return defrayAmount;
  }

  public void setDefrayAmount(BigDecimal defrayAmount) {
    this.defrayAmount = defrayAmount;
  }

  public PaymentInfo getPaymentInfo() {
    return paymentInfo;
  }

  public void setPaymentInfo(PaymentInfo paymentInfo) {
    this.paymentInfo = paymentInfo;
  }

  public Integer getDefrayStatus() {
    return defrayStatus;
  }

  public void setDefrayStatus(Integer defrayStatus) {
    this.defrayStatus = defrayStatus;
  }

  public Integer getFundsChannel() {
    return fundsChannel;
  }

  public void setFundsChannel(Integer fundsChannel) {
    this.fundsChannel = fundsChannel;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<DefrayAttachment> getDefrayAttachments() {
    return defrayAttachments;
  }

  public void setDefrayAttachments(Set<DefrayAttachment> defrayAttachments) {
    this.defrayAttachments = defrayAttachments;
  }

  public Date getDefrayTime() {
    return defrayTime;
  }

  public void setDefrayTime(Date defrayTime) {
    this.defrayTime = defrayTime;
  }

  public ElectronicAccount getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccount electronicAccount) {
    this.electronicAccount = electronicAccount;
  }

  public FundsAccount getFundsAccount() {
    return fundsAccount;
  }

  public void setFundsAccount(FundsAccount fundsAccount) {
    this.fundsAccount = fundsAccount;
  }
}
