package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 电子账户
 *
 * @Author: Paul Chan
 * @Date: 2021/4/7 下午5:43
 */
@Entity
@Table(name="`electronic_account`",
    indexes = @Index(columnList = "tenant_code", unique = true))
@ApiModel(value = "ElectronicAccount", description = "电子账户")
@org.hibernate.annotations.Table(appliesTo = "`electronic_account`", comment = "电子账户")
public class ElectronicAccount extends TenantOpEntity {
  private static final long serialVersionUID = 8765310116774799062L;

  /**
   * 账户绑定的唯一标识
   */
  @ApiModelProperty("账户绑定的唯一标识")
  @SaturnColumn(description = "账户绑定的唯一标识")
  @Column(name = "user_id", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '账户绑定的唯一标识'")
  private String userId;

  /**
   * 1：待审核，2：审核失败，3：预审成功，4：采集失败，5：待开户，6：开户失败，7：待绑卡，8：绑卡失败，9：待验证
   * ，10：验证失败，11：待签约，12：签约失败，13：待进件，14：进件中，15：进件失败，16：已启用
   */
  @Column(name = "apply_state", nullable = false, columnDefinition = "INT(11) COMMENT '申请状态：1：待预审核，2：预审核失败，3：待复审核，4：复审核失败，5：待签约，6：签约中，7：签约失败，8：已取消，9：已完成'")
  @SaturnColumn(description = "1：待审核，2：审核失败，3：预审成功，4：采集失败，5：待开户，6：开户失败，7：待绑卡，8：绑卡失败，9：待验证\\n\" +\n" +
      " ，10：验证失败，11：待签约，12：签约失败，13：待进件，14：进件中，15：进件失败，16：已启用")
  @ApiModelProperty("1：待审核，2：审核失败，3：预审成功，4：采集失败，5：待开户，6：开户失败，7：待绑卡，8：绑卡失败，9：待验证\\n\" +\n" +
      " ，10：验证失败，11：待签约，12：签约失败，13：待进件，14：进件中，15：进件失败，16：已启用")
  private Integer applyState;

  /**
   * 账单周期
   */
  @ApiModelProperty("账单周期")
  @SaturnColumn(description = "账单周期")
  @Column(name = "billing_cycle", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '账单周期'")
  private String billingCycle;

  /**
   * 最后失败原因
   */
  @ApiModelProperty("最后失败原因")
  @SaturnColumn(description = "最后失败原因")
  @Column(name = "latest_failure_reason", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '最后失败原因'")
  private String latestFailureReason;

  /**
   * 状态：0：申请中，1：已启用，2：已冻结
   */
  @ApiModelProperty("状态：0：申请中，1：已启用，2：已冻结")
  @SaturnColumn(description = "状态：0：申请中，1：已启用，2：已冻结")
  @Column(name = "state", nullable = false, columnDefinition = "INT(11) COMMENT '状态：0：申请中，1：已启用，2：已冻结'")
  private Integer state;

  /**
   *  绑卡状态 1.未绑卡 2.已绑卡 3.绑卡失败
   */
  @ApiModelProperty("绑卡状态 1.未绑卡 2.已绑卡 3.绑卡失败")
  @SaturnColumn(description = "绑卡状态 1.未绑卡 2.已绑卡 3.绑卡失败")
  @Column(name = "tied_card_status", nullable = false, columnDefinition = "INT(11) COMMENT '绑卡状态 1.未绑卡 2.已绑卡 3.绑卡失败'")
  private Integer tiedCardStatus;

  /**
   * 类型: 1、个体工商户，2：企业开户
   */
  @ApiModelProperty("类型: 1、个体工商户，2：企业开户")
  @SaturnColumn(description = "类型: 1、个体工商户，2：企业开户")
  @Column(name = "type", nullable = false, columnDefinition = "INT(11) COMMENT '类型: 1、个体工商户，2：企业开户'")
  private Integer type;

  /**
   * 签约人类型: 1、企业法人，2：经办人
   */
  @ApiModelProperty("签约人类型: 1、企业法人，2：经办人")
  @SaturnColumn(description = "签约人类型: 1、企业法人，2：经办人")
  @Column(name = "signer_type", nullable = false, columnDefinition = "INT(11) COMMENT '签约人类型: 1、企业法人，2：经办人'")
  private Integer signerType;

  /**
   * 经办人姓名
   */
  @ApiModelProperty("经办人姓名")
  @SaturnColumn(description = "经办人姓名")
  @Column(name = "signer_name", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '经办人姓名'")
  private String signerName;

  /**
   * 经办人身份证号
   */
  @ApiModelProperty("经办人身份证号")
  @SaturnColumn(description = "经办人身份证号")
  @Column(name = "signer_id_card_no", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '经办人身份证号'")
  private String signerIdCardNo;

  /**
   * 经办人手机号码
   */
  @ApiModelProperty("经办人手机号码")
  @SaturnColumn(description = "经办人手机号码")
  @Column(name = "signer_mobile", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '经办人手机号码'")
  private String signerMobile;

  /**
   * 商户编号（中心审核通过后返回的编号）
   */
  @ApiModelProperty("商户编号（中心审核通过后返回的编号）")
  @SaturnColumn(description = "商户编号（中心审核通过后返回的编号）")
  @Column(name = "merchant_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '商户编号（中心审核通过后返回的编号）'")
  private String merchantCode;

  /**
   * 商户名称（中心审核通过后返回的商户名称）
   */
  @ApiModelProperty("商户名称（中心审核通过后返回的商户名称）")
  @SaturnColumn(description = "商户名称（中心审核通过后返回的商户名称）")
  @Column(name = "merchant_name", length = 128, nullable = true, columnDefinition = "varchar(128) COMMENT '商户名称（中心审核通过后返回的商户名称）'")
  private String merchantName;

  /**
   * 开通时间
   */
  @ApiModelProperty("开通时间")
  @SaturnColumn(description = "开通时间")
  @Column(name = "open_time", nullable = true, columnDefinition = "datetime COMMENT '开通时间'")
  private Date openTime;

  /**
   * 到期时间
   */
  @ApiModelProperty("到期时间")
  @SaturnColumn(description = "到期时间")
  @Column(name = "expire_time", nullable = true, columnDefinition = "datetime COMMENT '到期时间'")
  private Date expireTime;

  /**
   * 预审核时间
   */
  @ApiModelProperty("预审核时间")
  @SaturnColumn(description = "预审核时间")
  @Column(name = "pre_apply_time", nullable = true, columnDefinition = "datetime COMMENT '预审核时间'")
  private Date preApplyTime;

  /**
   * 复审核时间
   */
  @ApiModelProperty("复审核时间")
  @SaturnColumn(description = "复审核时间")
  @Column(name = "repeated_apply_time", nullable = true, columnDefinition = "datetime COMMENT '复审核时间'")
  private Date repeatedApplyTime;

  /**
   * 签约时间
   */
  @ApiModelProperty("签约时间")
  @SaturnColumn(description = "签约时间")
  @Column(name = "sign_time", nullable = true, columnDefinition = "datetime COMMENT '签约时间'")
  private Date signTime;

  /**
   * 账户安全手机号
   */
  @ApiModelProperty("账户安全手机号")
  @SaturnColumn(description = "账户安全手机号")
  @Column(name = "security_mobile", nullable = true,  length=32 , columnDefinition = "VARCHAR(32) COMMENT ' 账户安全手机号 '")
  private String securityMobile;

  /**
   * 余额
   */
  @Column(name = "balance", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 余额 '")
  @SaturnColumn(description = "余额")
  @ApiModelProperty("余额")
  private BigDecimal balance;

  /**
   * 是否显示余额
   */
  @Column(name = "is_show_balance", nullable = false, columnDefinition = "bit(1) default 1 COMMENT ' 是否显示余额 '")
  @SaturnColumn(description = "是否显示余额")
  @ApiModelProperty("是否显示余额")
  private Boolean showBalance;

  /**
   * 微信appId
   */
  @ApiModelProperty("微信appId")
  @SaturnColumn(description = "微信appId")
  @Column(name = "app_id", nullable = true,  length=64 , columnDefinition = "VARCHAR(64) COMMENT ' 微信appId '")
  private String appId;

  /**
   * 电子账户开户信息
   */
  @ApiModelProperty("电子账户开户信息")
  @OneToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "电子账户开户信息")
  @JoinColumn(name = "electronic_account_info_id", nullable = false, columnDefinition = "varchar(255) COMMENT '电子账户开户信息'")
  private ElectronicAccountInfo accountInfo;

  /**
   * 电子账户证件信息
   */
  @ApiModelProperty("电子账户证件信息")
  @OneToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "电子账户证件信息")
  @JoinColumn(name = "electronic_account_certificate_id", nullable = false, columnDefinition = "varchar(255) COMMENT '电子账户证件信息'")
  private ElectronicAccountCertificate certificate;

  /**
   * 电子账户证件信息
   */
  @ApiModelProperty("电子账户证件信息")
  @SaturnColumn(description = "电子账户证件信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "electronicAccount")
  private Set<ElectronicAccountBank> banks;

  /**
   * 电子账户失败记录
   */
  @ApiModelProperty("电子账户失败记录")
  @SaturnColumn(description = "电子账户失败记录")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "electronicAccount")
  private Set<ElectronicAccountFailureRecord> failureRecords;

  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public Integer getApplyState() {
    return applyState;
  }

  public void setApplyState(Integer applyState) {
    this.applyState = applyState;
  }

  public String getLatestFailureReason() {
    return latestFailureReason;
  }

  public void setLatestFailureReason(String latestFailureReason) {
    this.latestFailureReason = latestFailureReason;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public Integer getTiedCardStatus() {
    return tiedCardStatus;
  }

  public void setTiedCardStatus(Integer tiedCardStatus) {
    this.tiedCardStatus = tiedCardStatus;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public Integer getSignerType() {
    return signerType;
  }

  public void setSignerType(Integer signerType) {
    this.signerType = signerType;
  }

  public String getSignerName() {
    return signerName;
  }

  public void setSignerName(String signerName) {
    this.signerName = signerName;
  }

  public String getSignerIdCardNo() {
    return signerIdCardNo;
  }

  public void setSignerIdCardNo(String signerIdCardNo) {
    this.signerIdCardNo = signerIdCardNo;
  }

  public String getSignerMobile() {
    return signerMobile;
  }

  public void setSignerMobile(String signerMobile) {
    this.signerMobile = signerMobile;
  }

  public String getMerchantCode() {
    return merchantCode;
  }

  public void setMerchantCode(String merchantCode) {
    this.merchantCode = merchantCode;
  }

  public String getMerchantName() {
    return merchantName;
  }

  public void setMerchantName(String merchantName) {
    this.merchantName = merchantName;
  }

  public Date getOpenTime() {
    return openTime;
  }

  public void setOpenTime(Date openTime) {
    this.openTime = openTime;
  }

  public Date getExpireTime() {
    return expireTime;
  }

  public void setExpireTime(Date expireTime) {
    this.expireTime = expireTime;
  }

  public Date getPreApplyTime() {
    return preApplyTime;
  }

  public void setPreApplyTime(Date preApplyTime) {
    this.preApplyTime = preApplyTime;
  }

  public Date getRepeatedApplyTime() {
    return repeatedApplyTime;
  }

  public void setRepeatedApplyTime(Date repeatedApplyTime) {
    this.repeatedApplyTime = repeatedApplyTime;
  }

  public Date getSignTime() {
    return signTime;
  }

  public void setSignTime(Date signTime) {
    this.signTime = signTime;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public ElectronicAccountInfo getAccountInfo() {
    return accountInfo;
  }

  public void setAccountInfo(ElectronicAccountInfo accountInfo) {
    this.accountInfo = accountInfo;
  }

  public ElectronicAccountCertificate getCertificate() {
    return certificate;
  }

  public void setCertificate(ElectronicAccountCertificate certificate) {
    this.certificate = certificate;
  }

  public Set<ElectronicAccountBank> getBanks() {
    return banks;
  }

  public void setBanks(Set<ElectronicAccountBank> banks) {
    this.banks = banks;
  }

  public Set<ElectronicAccountFailureRecord> getFailureRecords() {
    return failureRecords;
  }

  public void setFailureRecords(Set<ElectronicAccountFailureRecord> failureRecords) {
    this.failureRecords = failureRecords;
  }

  public String getSecurityMobile() {
    return securityMobile;
  }

  public void setSecurityMobile(String securityMobile) {
    this.securityMobile = securityMobile;
  }
  public String getBillingCycle() {
    return billingCycle;
  }

  public void setBillingCycle(String billingCycle) {
    this.billingCycle = billingCycle;
  }

  public Boolean getShowBalance() {
    return showBalance;
  }

  public void setShowBalance(Boolean showBalance) {
    this.showBalance = showBalance;
  }

  public String getAppId() {
    return appId;
  }

  public void setAppId(String appId) {
    this.appId = appId;
  }
}
