package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 电子账户银行信息
 * @Author: Paul Chan
 * @Date: 2021/4/8 下午2:25
 */
@Entity
@Table(name="`electronic_account_bank`")
@ApiModel(value = "ElectronicAccountBank", description = "电子账户银行信息")
@org.hibernate.annotations.Table(appliesTo = "`electronic_account_bank`", comment = "电子账户银行信息")
public class ElectronicAccountBank extends UuidEntity {
  private static final long serialVersionUID = 5378288135379998572L;

  /**
   * 状态：0：待验证，1：正常，2：已解绑
   */
  @ApiModelProperty("状态：0：待验证，1：正常，2：已解绑")
  @SaturnColumn(description = "状态：0：待验证，1：正常，2：已解绑")
  @Column(name = "state", nullable = false, columnDefinition = "int(11) COMMENT '状态：0：待验证，1：正常，2：已解绑'")
  private Integer state;

  /**
   * 经营者姓名
   */
  @ApiModelProperty("经营者姓名")
  @SaturnColumn(description = "经营者姓名")
  @Column(name = "management_name", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '经营者姓名'")
  private String managementName;

  /**
   * 身份证号
   */
  @ApiModelProperty("身份证号")
  @SaturnColumn(description = "身份证号")
  @Column(name = "id_card_no", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '身份证号'")
  private String idCardNo;

  /**
   * 银行ID
   */
  @ApiModelProperty("银行ID")
  @SaturnColumn(description = "银行ID")
  @Column(name = "bank_Id", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '银行ID'")
  private String bankId;

  /**
   * 银行卡账户名称
   */
  @ApiModelProperty("银行卡账户名称")
  @SaturnColumn(description = "银行卡账户名称")
  @Column(name = "bank_card_account_name", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '银行卡账户名称'")
  private String bankCardAccountName;

  /**
   * 银行卡号
   */
  @ApiModelProperty("银行卡号")
  @SaturnColumn(description = "银行卡号")
  @Column(name = "bank_card_no", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '银行卡号'")
  private String bankCardNo;

  /**
   * 开户银行
   */
  @ApiModelProperty("开户银行")
  @SaturnColumn(description = "开户银行")
  @Column(name = "bank_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '开户银行'")
  private String bankName;

  /**
   * 分支行名称
   */
  @ApiModelProperty("分支行名称")
  @SaturnColumn(description = "分支行名称")
  @Column(name = "bank_branch_name", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '分支行名称'")
  private String bankBranchName;

  /**
   * 银行卡预留手机号
   */
  @ApiModelProperty("银行卡预留手机号")
  @SaturnColumn(description = "银行卡预留手机号")
  @Column(name = "mobile", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '银行卡预留手机号'")
  private String mobile;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @SaturnColumn(description = "省编码")
  @Column(name = "province_code", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '省编码'")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  @SaturnColumn(description = "省名称")
  @Column(name = "province_name", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '省名称'")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @SaturnColumn(description = "市编码")
  @Column(name = "city_code", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '市编码'")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  @SaturnColumn(description = "市名称")
  @Column(name = "city_name", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '市名称'")
  private String cityName;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  @SaturnColumn(description = "区编码")
  @Column(name = "district_code", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '区编码'")
  private String districtCode;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  @SaturnColumn(description = "区名称")
  @Column(name = "district_name", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '区名称'")
  private String districtName;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "electronic_account_id", nullable = false, columnDefinition = "varchar(255) COMMENT '电子账户ID'")
  private ElectronicAccount electronicAccount;

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getManagementName() {
    return managementName;
  }

  public void setManagementName(String managementName) {
    this.managementName = managementName;
  }

  public String getIdCardNo() {
    return idCardNo;
  }

  public void setIdCardNo(String idCardNo) {
    this.idCardNo = idCardNo;
  }

  public String getBankId() {
    return bankId;
  }

  public void setBankId(String bankId) {
    this.bankId = bankId;
  }

  public String getBankCardAccountName() {
    return bankCardAccountName;
  }

  public void setBankCardAccountName(String bankCardAccountName) {
    this.bankCardAccountName = bankCardAccountName;
  }

  public String getBankCardNo() {
    return bankCardNo;
  }

  public void setBankCardNo(String bankCardNo) {
    this.bankCardNo = bankCardNo;
  }

  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  public String getBankBranchName() {
    return bankBranchName;
  }

  public void setBankBranchName(String bankBranchName) {
    this.bankBranchName = bankBranchName;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getProvinceCode() {
    return provinceCode;
  }

  public void setProvinceCode(String provinceCode) {
    this.provinceCode = provinceCode;
  }

  public String getProvinceName() {
    return provinceName;
  }

  public void setProvinceName(String provinceName) {
    this.provinceName = provinceName;
  }

  public String getCityCode() {
    return cityCode;
  }

  public void setCityCode(String cityCode) {
    this.cityCode = cityCode;
  }

  public String getCityName() {
    return cityName;
  }

  public void setCityName(String cityName) {
    this.cityName = cityName;
  }

  public String getDistrictCode() {
    return districtCode;
  }

  public void setDistrictCode(String districtCode) {
    this.districtCode = districtCode;
  }

  public String getDistrictName() {
    return districtName;
  }

  public void setDistrictName(String districtName) {
    this.districtName = districtName;
  }

  public ElectronicAccount getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccount electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
