package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 电子账户流水表
 * @Author: Paul Chan
 * @Date: 2021/4/20 上午11:02
 */
@Entity
@Table(name="`electronic_account_bill`")
@ApiModel(value = "ElectronicAccountBill", description = "电子账户流水表")
@org.hibernate.annotations.Table(appliesTo = "`electronic_account_bill`", comment = "电子账户流水表")
public class ElectronicAccountBill extends UuidOpEntity {
  private static final long serialVersionUID = 6468725597785391238L;

  /**
   * 操作类型，1：收入 2：支出
   */
  @Column(name = "type", nullable = false, columnDefinition = "INT(11) COMMENT ' 操作类型，1：收入 2：支出 '")
  @SaturnColumn(description = "操作类型，1：收入 2：支出")
  @ApiModelProperty("操作类型，1：收入 2：支出")
  private Integer type;

  /**
   * 流水状态，0：处理中 1：成功，2：失败
   */
  @Column(name = "state", nullable = false, columnDefinition = "INT(11) COMMENT ' 流水状态，0：处理中 1：成功，2：失败 '")
  @SaturnColumn(description = "流水状态，0：处理中 1：成功，2：失败")
  @ApiModelProperty("流水状态，0：处理中 1：成功，2：失败")
  private Integer state;

  /**
   * 流水单号
   */
  @Column(name = "bill_no", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 流水单号 '")
  @SaturnColumn(description = "流水单号")
  @ApiModelProperty("流水单号")
  private String billNo;

  /**
   * 业务类型，1：提现、2：应收、3：退货退款
   */
  @Column(name = "business_type", nullable = false, columnDefinition = "INT(11) COMMENT ' 业务类型，1：提现、2：应收、3：退货退款 '")
  @SaturnColumn(description = "业务类型，1：提现、2：应收、3：退货退款")
  @ApiModelProperty("业务类型，1：提现、2：应收、3：退货退款")
  private Integer businessType;

  /**
   * 业务单号
   */
  @Column(name = "business_no", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 业务单号 '")
  @SaturnColumn(description = "业务单号")
  @ApiModelProperty("业务单号")
  private String businessNo;

  /**
   * 交易金额
   */
  @Column(name = "amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 交易金额 '")
  @SaturnColumn(description = "交易金额")
  @ApiModelProperty("交易金额")
  private BigDecimal amount;

  /**
   * 手续费率
   */
  @Column(name = "charge_rate", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 手续费率 '")
  @SaturnColumn(description = "手续费率")
  @ApiModelProperty("手续费率")
  private BigDecimal chargeRate;

  /**
   * 手续费类型：1：比率，2：固定金额
   */
  @Column(name = "charge_rate_type", nullable = false, columnDefinition = "INT(11) COMMENT ' 手续费类型：1：比率，2：固定金额 '")
  @SaturnColumn(description = "手续费类型：1：比率，2：固定金额")
  @ApiModelProperty("手续费类型：1：比率，2：固定金额")
  private Integer chargeRateType;

  /**
   * 手续费
   */
  @Column(name = "charge_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 手续费 '")
  @SaturnColumn(description = "手续费")
  @ApiModelProperty("手续费")
  private BigDecimal chargeAmount;

  /**
   * 实际收支金额
   */
  @Column(name = "real_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 实际收支金额 '")
  @SaturnColumn(description = "实际收支金额")
  @ApiModelProperty("实际收支金额")
  private BigDecimal realAmount;

  /**
   * 交易来源
   */
  @Column(name = "deal_from", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 交易来源 '")
  @SaturnColumn(description = "交易来源")
  @ApiModelProperty("交易来源")
  private String dealFrom;

  /**
   * 剩余额度
   */
  @Column(name = "balance", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 剩余额度 '")
  @SaturnColumn(description = "剩余额度")
  @ApiModelProperty("剩余额度")
  private BigDecimal balance;

  /**
   * 备注
   */
  @Column(name = "remark", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 备注 '")
  @SaturnColumn(description = "备注")
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "electronic_account_id", nullable = false, columnDefinition = "varchar(255) COMMENT '电子账户ID'")
  private ElectronicAccount electronicAccount;

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  public Integer getBusinessType() {
    return businessType;
  }

  public void setBusinessType(Integer businessType) {
    this.businessType = businessType;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public BigDecimal getChargeRate() {
    return chargeRate;
  }

  public void setChargeRate(BigDecimal chargeRate) {
    this.chargeRate = chargeRate;
  }

  public Integer getChargeRateType() {
    return chargeRateType;
  }

  public void setChargeRateType(Integer chargeRateType) {
    this.chargeRateType = chargeRateType;
  }

  public BigDecimal getChargeAmount() {
    return chargeAmount;
  }

  public void setChargeAmount(BigDecimal chargeAmount) {
    this.chargeAmount = chargeAmount;
  }

  public BigDecimal getRealAmount() {
    return realAmount;
  }

  public void setRealAmount(BigDecimal realAmount) {
    this.realAmount = realAmount;
  }

  public String getDealFrom() {
    return dealFrom;
  }

  public void setDealFrom(String dealFrom) {
    this.dealFrom = dealFrom;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public ElectronicAccount getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccount electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
