package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 电子账户每日统计数据
 * @Author: Paul Chan
 * @Date: 2021/4/25 上午10:14
 */
@Entity
@Table(name="`electronic_account_bill_day_statistics`",
    indexes = @Index(columnList = "electronic_account_id,statistics_day", unique = true))
@ApiModel(value = "ElectronicAccountBillDayStatistics", description = "电子账户每日统计数据")
@org.hibernate.annotations.Table(appliesTo = "`electronic_account_bill_day_statistics`", comment = "电子账户每日统计数据")
public class ElectronicAccountBillDayStatistics extends UuidEntity {
  private static final long serialVersionUID = -3920711609753465847L;

  /**
   * 日期
   */
  @ApiModelProperty("日期")
  @SaturnColumn(description = "日期")
  @JsonFormat(pattern = "yyyy-MM-dd")
  @Column(name = "statistics_day", nullable = false, columnDefinition = "date COMMENT ' 日期 '")
  private Date day;

  /**
   * 收入金额
   */
  @Column(name = "receipt_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 收入金额 '")
  @SaturnColumn(description = "收入金额")
  @ApiModelProperty("收入金额")
  private BigDecimal receiptAmount;

  /**
   * 支出金额
   */
  @Column(name = "payment_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 支出金额 '")
  @SaturnColumn(description = "支出金额")
  @ApiModelProperty("支出金额")
  private BigDecimal paymentAmount;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "electronic_account_id", nullable = false, columnDefinition = "varchar(255) COMMENT '电子账户ID'")
  private ElectronicAccount electronicAccount;

  public Date getDay() {
    return day;
  }

  public void setDay(Date day) {
    this.day = day;
  }

  public BigDecimal getReceiptAmount() {
    return receiptAmount;
  }

  public void setReceiptAmount(BigDecimal receiptAmount) {
    this.receiptAmount = receiptAmount;
  }

  public BigDecimal getPaymentAmount() {
    return paymentAmount;
  }

  public void setPaymentAmount(BigDecimal paymentAmount) {
    this.paymentAmount = paymentAmount;
  }

  public ElectronicAccount getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccount electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
