package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 电子账户证件资料
 *
 * @Author: Paul Chan
 * @Date: 2021/4/8 上午10:54
 */
@Entity
@Table(name="`electronic_account_certificate`")
@ApiModel(value = "ElectronicAccountCertificate", description = "电子账户证件资料")
@org.hibernate.annotations.Table(appliesTo = "`electronic_account_certificate`", comment = "电子账户证件资料")
public class ElectronicAccountCertificate extends UuidEntity {
  private static final long serialVersionUID = -4920597931973457761L;

  /**
   * 营业执照图片文件夹
   */
  @ApiModelProperty("营业执照图片文件夹")
  @SaturnColumn(description = "营业执照图片文件夹")
  @Column(name = "business_license_path", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '营业执照图片文件夹'")
  private String businessLicensePath;

  /**
   * 营业执照图片文件名
   */
  @ApiModelProperty("营业执照图片文件名")
  @SaturnColumn(description = "营业执照图片文件名")
  @Column(name = "business_license_filename", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '营业执照图片文件名'")
  private String businessLicenseFilename;

  /**
   * 个体工商注册号码
   */
  @ApiModelProperty("个体工商注册号码")
  @SaturnColumn(description = "个体工商注册号码")
  @Column(name = "business_no", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '个体工商注册号码'")
  private String businessNo;

  /**
   * 个体工商字号
   */
  @ApiModelProperty("个体工商字号")
  @SaturnColumn(description = "个体工商字号")
  @Column(name = "business_shop_name", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '个体工商字号'")
  private String businessShopName;

  /**
   * 营业执照发证日
   */
  @ApiModelProperty("营业执照发证日")
  @JsonFormat(pattern = "yyyy-MM-dd")
  @SaturnColumn(description = "营业执照发证日")
  @Column(name = "business_license_issue_date", nullable = true, columnDefinition = "date COMMENT '营业执照发证日'")
  private Date businessLicenseIssueDate;

  /**
   * 营业执照到期日
   */
  @ApiModelProperty("营业执照到期日")
  @JsonFormat(pattern = "yyyy-MM-dd")
  @SaturnColumn(description = "营业执照到期日")
  @Column(name = "business_license_expire_date", nullable = true, columnDefinition = "date COMMENT '营业执照到期日'")
  private Date businessLicenseExpireDate;

  /**
   * 形成形式 1:个人经营,2:家庭经营
   */
  @ApiModelProperty("形成形式 1:个人经营,2:家庭经营")
  @SaturnColumn(description = "形成形式 1:个人经营,2:家庭经营")
  @Column(name = "org_type", length = 11, nullable = true, columnDefinition = "varchar(11) COMMENT '形成形式 1:个人经营,2:家庭经营'")
  private String orgType;

  /**
   * 经营地址
   */
  @ApiModelProperty("经营地址")
  @SaturnColumn(description = "经营地址")
  @Column(name = "address", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '经营地址'")
  private String address;

  /**
   * 经营范围
   */
  @ApiModelProperty("经营范围")
  @SaturnColumn(description = "经营范围")
  @Column(name = "business_scope", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '经营范围'")
  private String businessScope;

  /**
   * 身份证正面文件夹
   */
  @ApiModelProperty("身份证正面文件夹")
  @SaturnColumn(description = "身份证正面文件夹")
  @Column(name = "id_card_front_path", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '身份证正面文件夹'")
  private String idCardFrontPath;

  /**
   * 身份证正面文件名
   */
  @ApiModelProperty("身份证正面文件名")
  @SaturnColumn(description = "身份证正面文件名")
  @Column(name = "id_card_front_filename", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '身份证正面文件名'")
  private String idCardFrontFilename;

  /**
   * 身份证背面文件夹
   */
  @ApiModelProperty("身份证背面文件夹")
  @SaturnColumn(description = "身份证背面文件夹")
  @Column(name = "id_card_back_path", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '身份证背面文件夹'")
  private String idCardBackPath;

  /**
   * 身份证背面文件名
   */
  @ApiModelProperty("身份证背面文件名")
  @SaturnColumn(description = "身份证背面文件名")
  @Column(name = "id_card_back_filename", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '身份证背面文件名'")
  private String idCardBackFilename;

  /**
   * 身份证号
   */
  @ApiModelProperty("身份证号")
  @SaturnColumn(description = "身份证号")
  @Column(name = "id_card_no", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '身份证号'")
  private String idCardNo;

  /**
   * 身份证发证日期
   */
  @ApiModelProperty("身份证发证日期")
  @JsonFormat(pattern = "yyyy-MM-dd")
  @SaturnColumn(description = "身份证发证日期")
  @Column(name = "id_card_issue_date", nullable = false, columnDefinition = "date COMMENT '身份证发证日期'")
  private Date idCardIssueDate;

  /**
   * 身份证过期日期
   */
  @ApiModelProperty("c")
  @JsonFormat(pattern = "yyyy-MM-dd")
  @SaturnColumn(description = "身份证过期日期")
  @Column(name = "id_card_expire_date", nullable = true, columnDefinition = "date COMMENT '身份证过期日期'")
  private Date idCardExpireDate;

  //  企业开户

  /**
   * 统一社会信用代码
   */
  @ApiModelProperty("统一社会信用代码")
  @SaturnColumn(description = "统一社会信用代码")
  @Column(name = "social_credit_code", length = 64, nullable = true, columnDefinition = "varchar(32) COMMENT '统一社会信用代码'")
  private String socialCreditCode;

  /**
   * 注册资本
   */
  @ApiModelProperty("注册资本")
  @SaturnColumn(description = "注册资本")
  @Column(name = "registered_capital", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '注册资本'")
  private BigDecimal registeredCapital;

  /**
   * 法人姓名
   */
  @ApiModelProperty("法人姓名")
  @SaturnColumn(description = "法人姓名")
  @Column(name = "legal_person_name", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '法人姓名'")
  private String legalPersonName;

  /**
   * 法人手机号
   */
  @ApiModelProperty("法人手机号")
  @SaturnColumn(description = "法人手机号")
  @Column(name = "legal_person_mobile", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '法人手机号'")
  private String legalPersonMobile;

  /**
   * 法人邮箱
   */
  @ApiModelProperty("法人邮箱")
  @SaturnColumn(description = "法人邮箱")
  @Column(name = "legal_person_email", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '法人邮箱'")
  private String legalPersonEmail;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @OneToOne(fetch = FetchType.LAZY, mappedBy = "certificate")
  private ElectronicAccount electronicAccount;

  public String getBusinessLicensePath() {
    return businessLicensePath;
  }

  public void setBusinessLicensePath(String businessLicensePath) {
    this.businessLicensePath = businessLicensePath;
  }

  public String getBusinessLicenseFilename() {
    return businessLicenseFilename;
  }

  public void setBusinessLicenseFilename(String businessLicenseFilename) {
    this.businessLicenseFilename = businessLicenseFilename;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public String getBusinessShopName() {
    return businessShopName;
  }

  public void setBusinessShopName(String businessShopName) {
    this.businessShopName = businessShopName;
  }

  public Date getBusinessLicenseIssueDate() {
    return businessLicenseIssueDate;
  }

  public void setBusinessLicenseIssueDate(Date businessLicenseIssueDate) {
    this.businessLicenseIssueDate = businessLicenseIssueDate;
  }

  public Date getBusinessLicenseExpireDate() {
    return businessLicenseExpireDate;
  }

  public void setBusinessLicenseExpireDate(Date businessLicenseExpireDate) {
    this.businessLicenseExpireDate = businessLicenseExpireDate;
  }

  public String getOrgType() {
    return orgType;
  }

  public void setOrgType(String orgType) {
    this.orgType = orgType;
  }

  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public String getBusinessScope() {
    return businessScope;
  }

  public void setBusinessScope(String businessScope) {
    this.businessScope = businessScope;
  }

  public String getIdCardFrontPath() {
    return idCardFrontPath;
  }

  public void setIdCardFrontPath(String idCardFrontPath) {
    this.idCardFrontPath = idCardFrontPath;
  }

  public String getIdCardFrontFilename() {
    return idCardFrontFilename;
  }

  public void setIdCardFrontFilename(String idCardFrontFilename) {
    this.idCardFrontFilename = idCardFrontFilename;
  }

  public String getIdCardBackPath() {
    return idCardBackPath;
  }

  public void setIdCardBackPath(String idCardBackPath) {
    this.idCardBackPath = idCardBackPath;
  }

  public String getIdCardBackFilename() {
    return idCardBackFilename;
  }

  public void setIdCardBackFilename(String idCardBackFilename) {
    this.idCardBackFilename = idCardBackFilename;
  }

  public String getIdCardNo() {
    return idCardNo;
  }

  public void setIdCardNo(String idCardNo) {
    this.idCardNo = idCardNo;
  }

  public Date getIdCardIssueDate() {
    return idCardIssueDate;
  }

  public void setIdCardIssueDate(Date idCardIssueDate) {
    this.idCardIssueDate = idCardIssueDate;
  }

  public Date getIdCardExpireDate() {
    return idCardExpireDate;
  }

  public void setIdCardExpireDate(Date idCardExpireDate) {
    this.idCardExpireDate = idCardExpireDate;
  }

  public String getSocialCreditCode() {
    return socialCreditCode;
  }

  public void setSocialCreditCode(String socialCreditCode) {
    this.socialCreditCode = socialCreditCode;
  }

  public BigDecimal getRegisteredCapital() {
    return registeredCapital;
  }

  public void setRegisteredCapital(BigDecimal registeredCapital) {
    this.registeredCapital = registeredCapital;
  }

  public String getLegalPersonName() {
    return legalPersonName;
  }

  public void setLegalPersonName(String legalPersonName) {
    this.legalPersonName = legalPersonName;
  }

  public String getLegalPersonMobile() {
    return legalPersonMobile;
  }

  public void setLegalPersonMobile(String legalPersonMobile) {
    this.legalPersonMobile = legalPersonMobile;
  }

  public String getLegalPersonEmail() {
    return legalPersonEmail;
  }

  public void setLegalPersonEmail(String legalPersonEmail) {
    this.legalPersonEmail = legalPersonEmail;
  }

  public ElectronicAccount getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccount electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
