package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.util.Date;

/**
 * 电子账户失败记录
 * @Author: Paul Chan
 * @Date: 2021/4/9 上午11:12
 */
@Entity
@Table(name="`electronic_account_failure_record`")
@ApiModel(value = "ElectronicAccountFailureRecord", description = "电子账户失败记录")
@org.hibernate.annotations.Table(appliesTo = "`electronic_account_failure_record`", comment = "电子账户失败记录")
public class ElectronicAccountFailureRecord extends UuidEntity {
  private static final long serialVersionUID = 6794607795995217887L;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @SaturnColumn(description = "创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  private Date createTime;

  /**
   * 失败原因
   */
  @ApiModelProperty("失败原因")
  @SaturnColumn(description = "失败原因")
  @Column(name = "failure_reason", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '失败原因'")
  private String failureReason;

  /**
   * 电子账户
   */
  @ApiModelProperty("电子账户")
  @SaturnColumn(description = "电子账户")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "electronic_account_id", nullable = false, columnDefinition = "varchar(255) COMMENT '电子账户ID'")
  private ElectronicAccount electronicAccount;

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getFailureReason() {
    return failureReason;
  }

  public void setFailureReason(String failureReason) {
    this.failureReason = failureReason;
  }

  public ElectronicAccount getElectronicAccount() {
    return electronicAccount;
  }

  public void setElectronicAccount(ElectronicAccount electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
}
