package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 经销商的资金账户
 * @author Keller
 */
@ApiModel(value = "FundsAccount", description = "资金账户")
@Entity
@Table(name = "`funds_account`" , indexes = @Index(columnList = "tenant_code"))
@org.hibernate.annotations.Table(appliesTo = "`funds_account`", comment = "资金账户")
public class FundsAccount extends TenantOpEntity {

  private static final long serialVersionUID = -1259548582685122884L;
  /**
   * 账户名称
   */
  @Column(name = "name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 账户名称 '")
  @SaturnColumn(description = "账户名称")
  @ApiModelProperty("账户名称")
  private String name;

  /**
   * 开户银行
   */
  @Column(name = "bank", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 开户银行 '")
  @SaturnColumn(description = "开户银行")
  @ApiModelProperty("开户银行")
  private String bank;

  /**
   * 开户账号
   */
  @Column(name = "account", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 开户账号 '")
  @SaturnColumn(description = "开户账号")
  @ApiModelProperty("开户账号")
  private String account;

  /**
   * 账户状态 启用:1、禁用:0
   */
  @Column(name = "account_status", nullable = false, columnDefinition = "INT(11) COMMENT ' 账户状态 启用:1、禁用:0 '")
  @SaturnColumn(description = "账户状态 启用:1、禁用:0")
  @ApiModelProperty("账户状态 启用:1、禁用:0")
  private Integer accountStatus;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getBank() {
    return bank;
  }

  public void setBank(String bank) {
    this.bank = bank;
  }

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public Integer getAccountStatus() {
    return accountStatus;
  }

  public void setAccountStatus(Integer accountStatus) {
    this.accountStatus = accountStatus;
  }
}
