package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Set;

/**
 * 应付账款，对应多张付款单
 * @author keller
 */
@ApiModel(value = "PaymentInfo", description = "应付账款")
@Entity
@Table(name = "`payment_info`", indexes = {@Index(columnList = "tenant_code , payment_code", unique = true),
                                           @Index(columnList = "tenant_code , associate_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "`payment_info`", comment = "应付账款")
@BuildCustomRepository
public class PaymentInfo extends TenantOpEntity  {
  /**
   * 
   */
  private static final long serialVersionUID = -2695780408472535608L;

  /**
   * 应付账款流水编号
   */
  @Column(name = "payment_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 应付账款流水编号 '")
  @SaturnColumn(description = "应付账款流水编号")
  @ApiModelProperty("应付账款流水编号")
  private String paymentCode;
  /** 客户编号 */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  @Column(name = "customer_code", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户编号 '")
  private String customerCode;
  /** 客户名称 */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  @Column(name = "customer_name", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 客户名称 '")
  private String customerName;
  /**
   * 应付账款对应的关联单据编号
   */
  @Column(name = "associate_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联单据编号 '")
  @SaturnColumn(description = "关联单据编号")
  @ApiModelProperty("关联单据编号")
  private String associatedCode;
  /**
   * 应付金额  应付金额=待付金额+已付金额
   *
   */
  @Column(name = "pay_amount", nullable = false, precision = 20, scale = 4,columnDefinition = "DECIMAL(20,4) COMMENT '应付金额'")
  @SaturnColumn(description = "应付金额")
  @ApiModelProperty("应付金额")
  private BigDecimal payAmount;
  /**
   * 待付金额 应付款单 待支付的金额
   */
  @Column(name = "wait_pay_amount", nullable = false, precision = 20, scale = 4,columnDefinition = "DECIMAL(20,4) COMMENT '待付金额'")
  @SaturnColumn(description = "待付金额")
  @ApiModelProperty("待付金额")
  private BigDecimal waitPayAmount;
  /**
   * 待确认金额 待确认付款金额（该金额包含在待付金额中，是待付金额至已付金额的一个过渡状态金额）
   */
  @Column(name = "wait_confirm_amount", nullable = false, precision = 20, scale = 4,columnDefinition = "DECIMAL(20,4) COMMENT '待确认金额'")
  @SaturnColumn(description = "待确认金额")
  @ApiModelProperty("待确认金额")
  private BigDecimal waitConfirmAmount;
  /**
   * 已付金额
   */
  @Column(name = "payed_amount", nullable = false, precision = 20, scale = 4,columnDefinition = "DECIMAL(20,4) COMMENT '已付金额'")
  @SaturnColumn(description = "已付金额")
  @ApiModelProperty("已付金额")
  private BigDecimal payedAmount;
  /**
   * 付款类型 其他付款:1,订单付款:2
   */
  @Column(name = "pay_type", nullable = false, columnDefinition = "INT COMMENT '付款类型 其他付款:1,订单付款:2'")
  @SaturnColumn(description = "付款类型 其他付款:1,订单付款:2")
  @ApiModelProperty("付款类型 其他付款:1,订单付款:2")
  private Integer payType;
  /**
   * 应付账款状态
   */
  @Column(name = "payment_status", nullable = false, columnDefinition = "INT COMMENT '应付账款状态：未付款1、部分付款2、已付款3'")
  @SaturnColumn(description = "应付账款状态")
  @ApiModelProperty("应付账款状态：未付款1、部分付款2、已付款3")
  private Integer paymentStatus;
  /**
   * 应付账款单据状态： 正常:1、报废:0
   */
  @Column(name = "tstatus", nullable = false, columnDefinition = "INT COMMENT '应付账款单据状态：正常:1、报废:0'")
  @SaturnColumn(description = "应付账款单据状态")
  @ApiModelProperty("应付账款单据状态：正常:1、报废:0")
  private Integer tstatus;

  /**
   * 应付账款对应的一张或者多张付款单
   */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "paymentInfo")
  @SaturnColumn(description = "付款单")
  @ApiModelProperty("付款单")
  @OrderBy("defrayTime desc")
  private Set<DefrayInfo> defrayInfos;

  public String getPaymentCode() {
    return paymentCode;
  }

  public void setPaymentCode(String paymentCode) {
    this.paymentCode = paymentCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public BigDecimal getPayAmount() {
    return payAmount;
  }

  public void setPayAmount(BigDecimal payAmount) {
    this.payAmount = payAmount;
  }

  public BigDecimal getWaitPayAmount() {
    return waitPayAmount;
  }

  public void setWaitPayAmount(BigDecimal waitPayAmount) {
    this.waitPayAmount = waitPayAmount;
  }

  public BigDecimal getWaitConfirmAmount() {
    return waitConfirmAmount;
  }

  public void setWaitConfirmAmount(BigDecimal waitConfirmAmount) {
    this.waitConfirmAmount = waitConfirmAmount;
  }

  public BigDecimal getPayedAmount() {
    return payedAmount;
  }

  public void setPayedAmount(BigDecimal payedAmount) {
    this.payedAmount = payedAmount;
  }

  public Integer getPayType() {
    return payType;
  }

  public void setPayType(Integer payType) {
    this.payType = payType;
  }

  public Set<DefrayInfo> getDefrayInfos() {
    return defrayInfos;
  }

  public void setDefrayInfos(Set<DefrayInfo> defrayInfos) {
    this.defrayInfos = defrayInfos;
  }

  public Integer getPaymentStatus() {
    return paymentStatus;
  }

  public void setPaymentStatus(Integer paymentStatus) {
    this.paymentStatus = paymentStatus;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
}
