package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 收款单文件
 * @author Keller
 */
@ApiModel(value = "ReceiptAttachment", description = "收款单附件")
@Entity
@Table(name = "`receipt_attachment`")
@org.hibernate.annotations.Table(appliesTo = "`receipt_attachment`", comment = "收款单附件")
public class ReceiptAttachment extends UuidOpEntity {

  private static final long serialVersionUID = 3812659127468084748L;

  /**
   * 相对路径
   */
  @Column(name = "relative_path", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;
  /**
   * 原始文件名
   */
  @Column(name = "file_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '原始文件名 '")
  @SaturnColumn(description = "原始文件名")
  @ApiModelProperty("原始文件名")
  private String fileName;
  /**
   * 重命名后的文件名
   */
  @Column(name = "refile_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '重命名后的文件名 '")
  @SaturnColumn(description = "重命名后的文件名")
  @ApiModelProperty("重命名后的文件名")
  private String reFileName;

  /**
   * 收款单编号
   */
  @ManyToOne(fetch = FetchType.LAZY, targetEntity = ReceiptInfo.class)
  @JoinColumn(name = "receipt_id",nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 收款单编号 '")
  @SaturnColumn(description = "收款单编号")
  private ReceiptInfo receiptInfo;

  public ReceiptInfo getReceiptInfo() {
    return receiptInfo;
  }

  public void setReceiptInfo(ReceiptInfo receiptInfo) {
    this.receiptInfo = receiptInfo;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getReFileName() {
    return reFileName;
  }

  public void setReFileName(String reFileName) {
    this.reFileName = reFileName;
  }
}
