package com.bizunited.empower.business.payment.entity;

import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 收款单
 * @author Keller
 */
@ApiModel(value = "ReceiptInfo", description = "收款单")
@Entity
@Table(name = "`receipt_info`", indexes = {@Index(columnList = "tenant_code , receipt_code", unique = true),
                                           @Index(columnList = "tenant_code , customer_code")})
@org.hibernate.annotations.Table(appliesTo = "`receipt_info`", comment = "收款单")
@BuildCustomRepository
public class ReceiptInfo extends TenantOpEntity {

  /**
   *
   */
  private static final long serialVersionUID = -3565381725075577875L;

  /**
   * 收款单流水编号
   */
  @Column(name = "receipt_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 收款单流水编号 '")
  @SaturnColumn(description = "收款单流水编号")
  @ApiModelProperty("收款单流水编号")
  private String receiptCode;
  /**
   * 交易流水编号
   */
  @Column(name = "tx_sn", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 交易流水编号 '")
  @SaturnColumn(description = "交易流水编号")
  @ApiModelProperty("交易流水编号")
  private String txSN;
  /**
   * 应收账款客户编号
   */
  @Column(name = "customer_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户编号 '")
  @SaturnColumn(description = "客户编号")
  @ApiModelProperty("客户编号")
  private String customerCode;
  /**
   * 收款金额
   */
  @Column(name = "receipt_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '收款金额'")
  @SaturnColumn(description = "收款金额")
  @ApiModelProperty("收款金额")
  private BigDecimal receiptAmount;
  /**
   * 收款单状态 待确认:1、已确认:2、已取消:0
   */
  @Column(name = "receipt_status", nullable = false, columnDefinition = "INT COMMENT '收款单状态：待确认:1、已确认:2、已取消:0'")
  @SaturnColumn(description = "收款单状态")
  @ApiModelProperty("收款单状态：待确认:1、已确认:2、已取消:0")
  private Integer receiptStatus;
  /**
   * 资金渠道 {@link FundsChannelType}
   */
  @Column(name = "funds_channel", nullable = false, columnDefinition = "INT COMMENT '资金渠道 支付宝:1、微信小程序支付:2、聚合支付:3、现金支付:4、 银行转账:5、 信用支付:6'")
  @SaturnColumn(description = "资金渠道 支付宝:1、微信小程序支付:2、聚合支付:3、现金支付:4、 银行转账:5、 信用支付:6")
  @ApiModelProperty("资金渠道 支付宝:1、微信小程序支付:2、银联支付:3、聚合支付:4、 银行转账:5、 信用支付:6")
  private Integer fundsChannel;
  /**
   * 备注信息
   */
  @SaturnColumn(description = "备注信息")
  @ApiModelProperty("备注信息")
  @Column(name="remark", nullable = true, columnDefinition = "VARCHAR(2000) COMMENT ' 备注信息 '")
  private String remark;
  /**
   * 收款时间
   */
  @ApiModelProperty(name = "receiptTime", value = "收款时间", required = true)
  @Column(name = "receipt_time" , columnDefinition = "datetime COMMENT '收款时间'")
  @SaturnColumn(description = "收款时间")
  private Date receiptTime;

  /**
   * 收款电子账户
   */
  @JoinColumn(name = "electronic_account_id", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 收款电子账户 '")
  @SaturnColumn(description = "收款电子账户")
  @ApiModelProperty("收款电子账户")
  @ManyToOne(fetch = FetchType.LAZY)
  private ElectronicAccount electronicAccount;

  /**
   * 收款账户
   */
  @JoinColumn(name = "receipt_account", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 收款账户 '")
  @SaturnColumn(description = "收款账户")
  @ApiModelProperty("收款账户")
  @ManyToOne(fetch = FetchType.LAZY)
  private FundsAccount fundsAccount;

  /**
   * 应收账款编号
   */
  @SaturnColumn(description = "应收账款")
  @ApiModelProperty("应收账款编号")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name="receivable_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 应收账款编号 '")
  private ReceivableInfo receivableInfo;

  /**
   * 收款单附件
   */
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "receiptInfo")
  @SaturnColumn(description = "收款单附件")
  @ApiModelProperty("收款单附件")
  private Set<ReceiptAttachment> receiptAttachments;

  public String getReceiptCode() {
    return receiptCode;
  }
  public void setReceiptCode(String receiptCode) {
    this.receiptCode = receiptCode;
  }
  public String getCustomerCode() {
    return customerCode;
  }
  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }
  public BigDecimal getReceiptAmount() {
    return receiptAmount;
  }
  public void setReceiptAmount(BigDecimal receiptAmount) {
    this.receiptAmount = receiptAmount;
  }
  public ReceivableInfo getReceivableInfo() {
    return receivableInfo;
  }
  public void setReceivableInfo(ReceivableInfo receivableInfo) {
    this.receivableInfo = receivableInfo;
  }
  public Integer getReceiptStatus() {
    return receiptStatus;
  }
  public void setReceiptStatus(Integer receiptStatus) {
    this.receiptStatus = receiptStatus;
  }
  public Integer getFundsChannel() {
    return fundsChannel;
  }
  public void setFundsChannel(Integer fundsChannel) {
    this.fundsChannel = fundsChannel;
  }
  public String getRemark() {
    return remark;
  }
  public void setRemark(String remark) {
    this.remark = remark;
  }
  public Set<ReceiptAttachment> getReceiptFiles() {
    return receiptAttachments;
  }
  public void setReceiptFiles(Set<ReceiptAttachment> receiptAttachments) {
    this.receiptAttachments = receiptAttachments;
  }
  public Set<ReceiptAttachment> getReceiptAttachments() {
    return receiptAttachments;
  }
  public void setReceiptAttachments(Set<ReceiptAttachment> receiptAttachments) {
    this.receiptAttachments = receiptAttachments;
  }
  public Date getReceiptTime() {
    return receiptTime;
  }
  public void setReceiptTime(Date receiptTime) {
    this.receiptTime = receiptTime;
  }
  public String getTxSN() {
    return txSN;
  }
  public void setTxSN(String txSN) {
    this.txSN = txSN;
  }
  public ElectronicAccount getElectronicAccount() {
    return electronicAccount;
  }
  public void setElectronicAccount(ElectronicAccount electronicAccount) {
    this.electronicAccount = electronicAccount;
  }
  public FundsAccount getFundsAccount() {
    return fundsAccount;
  }
  public void setFundsAccount(FundsAccount fundsAccount) {
    this.fundsAccount = fundsAccount;
  }
}
