package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Set;

/**
 * 应收账款
 * @author Keller
 */
@ApiModel(value = "ReceivableInfo", description = "应收账款")
@Entity
@Table(name = "`receivable_info`", indexes = {@Index(columnList = "tenant_code , receivable_code", unique = true),
                                              @Index(columnList = "tenant_code , associate_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "`receivable_info`", comment = "应收账款")
@BuildCustomRepository
public class ReceivableInfo extends TenantOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -7256508714512464214L;
  /**
   * 应收账款流水编号
   */
  @Column(name = "receivable_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 应收账款流水编号 '")
  @SaturnColumn(description = "应收账款流水编号")
  @ApiModelProperty("应收账款流水编号")
  private String receivableCode;
  /** 客户编号 */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  @Column(name = "customer_code", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户编号 '")
  private String customerCode;
  /** 客户名称 */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  @Column(name = "customer_name", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 客户名称 '")
  private String customerName;
  /**
   * 应收账款对应的关联单据编号
   */
  @Column(name = "associate_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联单据编号 '")
  @SaturnColumn(description = "关联单据编号")
  @ApiModelProperty("关联单据编号")
  private String associatedCode;
  /**
   * 应收金额  应收金额=待收金额+已收金额
   *
   */
  @Column(name = "receivable_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '应收金额'")
  @SaturnColumn(description = "应收金额")
  @ApiModelProperty("应收金额")
  private BigDecimal receivableAmount;
  /**
   * 待收金额 应收款单 待收取的金额
   */
  @Column(name = "wait_receive_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '待收金额'")
  @SaturnColumn(description = "待收金额")
  @ApiModelProperty("待收金额")
  private BigDecimal waitReceiveAmount;
  /**
   * 待确认金额 待确认收取金额（该金额包含在待收金额中，是待收金额至已收金额的一个过渡状态金额）
   */
  @Column(name = "wait_confirm_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '待确认金额'")
  @SaturnColumn(description = "待确认金额")
  @ApiModelProperty("待确认金额")
  private BigDecimal waitConfirmAmount;
  /**
   * 已收金额
   */
  @Column(name = "received_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '已收金额'")
  @SaturnColumn(description = "已收金额")
  @ApiModelProperty("已收金额")
  private BigDecimal receivedAmount;
  /**
   * 收款类型 其他收款:1,订单收款:2
   */
  @Column(name = "receivable_type", nullable = false, columnDefinition = "INT COMMENT '收款类型 其他收款:1,订单收款:2'")
  @SaturnColumn(description = "收款类型 其他收款:1,订单收款:2")
  @ApiModelProperty("收款类型 其他收款:1,订单收款:2")
  private Integer receivableType;
  /**
   * 应收账款状态 未收款1、部分收款2、已收款3、终止4（需要有备注信息）、冲账5
   */
  @Column(name = "receivable_status", nullable = false, columnDefinition = "INT COMMENT '应收账款状态：未收款1、部分收款2、已收款3、终止4（需要有备注信息）、冲账5'")
  @SaturnColumn(description = "应收账款状态")
  @ApiModelProperty("应收账款状态：未收款1、部分收款2、已收款3、终止4（需要有备注信息）、冲账5")
  private Integer receivableStatus;
  /**
   * 应收账款单据状态： 正常:1、报废:0
   */
  @Column(name = "tstatus", nullable = false, columnDefinition = "INT COMMENT '应收账款单据状态：正常:1、报废:0'")
  @SaturnColumn(description = "应收账款单据状态")
  @ApiModelProperty("应收账款单据状态：正常:1、报废:0")
  private Integer tstatus;
  /**
   * 应收账款对应的一张或者多张收款单
   */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "receivableInfo")
  @SaturnColumn(description = "收款单")
  @ApiModelProperty("收款单")
  @OrderBy("receiptTime desc")
  private Set<ReceiptInfo> receiptInfos;
  public BigDecimal getReceivableAmount() {
    return receivableAmount;
  }

  public void setReceivableAmount(BigDecimal receivableAmount) {
    this.receivableAmount = receivableAmount;
  }

  public BigDecimal getWaitReceiveAmount() {
    return waitReceiveAmount;
  }

  public void setWaitReceiveAmount(BigDecimal waitReceiveAmount) {
    this.waitReceiveAmount = waitReceiveAmount;
  }

  public BigDecimal getWaitConfirmAmount() {
    return waitConfirmAmount;
  }

  public void setWaitConfirmAmount(BigDecimal waitConfirmAmount) {
    this.waitConfirmAmount = waitConfirmAmount;
  }

  public BigDecimal getReceivedAmount() {
    return receivedAmount;
  }

  public void setReceivedAmount(BigDecimal receivedAmount) {
    this.receivedAmount = receivedAmount;
  }

  public Set<ReceiptInfo> getReceiptInfos() {
    return receiptInfos;
  }

  public void setReceiptInfos(Set<ReceiptInfo> receiptInfos) {
    this.receiptInfos = receiptInfos;
  }

  public Integer getReceivableStatus() {
    return receivableStatus;
  }

  public void setReceivableStatus(Integer receivableStatus) {
    this.receivableStatus = receivableStatus;
  }

  public String getReceivableCode() {
    return receivableCode;
  }

  public void setReceivableCode(String receivableCode) {
    this.receivableCode = receivableCode;
  }

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Integer getReceivableType() {
    return receivableType;
  }

  public void setReceivableType(Integer receivableType) {
    this.receivableType = receivableType;
  }
}
