package com.bizunited.empower.business.payment.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 供应商应收账款
 *
 * @author Keller
 */
@ApiModel(value = "SupplierReceivableInfo", description = "供应商应收账款")
@Entity
@Table(name = "`supplier_receivable_info`", indexes = {@Index(columnList = "tenant_code , receivable_code", unique = true),
                                              @Index(columnList = "tenant_code , associate_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "`supplier_receivable_info`", comment = "供应商应收账款")
public class SupplierReceivableInfo extends TenantOpEntity {
  private static final long serialVersionUID = 513328236505163014L;
  /**
   * 应收账款流水编号
   */
  @Column(name = "receivable_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 应收账款流水编号 '")
  @SaturnColumn(description = "应收账款流水编号")
  @ApiModelProperty("应收账款流水编号")
  private String receivableCode;
  /** 供应商编号 */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  @Column(name = "supplier_code", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 客户编号 '")
  private String supplierCode;
  /** 供应商名称 */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  @Column(name = "supplier_name", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 客户名称 '")
  private String supplierName;
  /**
   * 应收账款对应的关联单据编号
   */
  @Column(name = "associate_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联单据编号 '")
  @SaturnColumn(description = "关联单据编号")
  @ApiModelProperty("关联单据编号")
  private String associatedCode;
  /**
   * 应收金额  应收金额=待收金额+已收金额
   *
   */
  @Column(name = "receivable_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '应收金额'")
  @SaturnColumn(description = "应收金额")
  @ApiModelProperty("应收金额")
  private BigDecimal receivableAmount;
  /**
   * 待收金额 应收款单 待收取的金额
   */
  @Column(name = "wait_receive_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '待收金额'")
  @SaturnColumn(description = "待收金额")
  @ApiModelProperty("待收金额")
  private BigDecimal waitReceiveAmount;
  /**
   * 已收金额
   */
  @Column(name = "received_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '已收金额'")
  @SaturnColumn(description = "已收金额")
  @ApiModelProperty("已收金额")
  private BigDecimal receivedAmount;
  /**
   * 应收账款状态 未收款1、已收款2
   */
  @Column(name = "receivable_status", nullable = false, columnDefinition = "INT COMMENT '应收账款状态 未收款1、已收款2'")
  @SaturnColumn(description = "应收账款状态 未收款1、已收款2")
  @ApiModelProperty("应收账款状态 未收款1、已收款2")
  private Integer receivableStatus;
  /**
   * 应收账款单据状态： 正常:1、报废:0
   */
  @Column(name = "tstatus", nullable = false, columnDefinition = "INT COMMENT '应收账款单据状态：正常:1、报废:0'")
  @SaturnColumn(description = "应收账款单据状态")
  @ApiModelProperty("应收账款单据状态：正常:1、报废:0")
  private Integer tstatus;

  @Column(name = "receivable_time", nullable = true, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "支付时间")
  @ApiModelProperty("支付时间")
  private Date receivableTime;

  public String getReceivableCode() {
    return receivableCode;
  }

  public void setReceivableCode(String receivableCode) {
    this.receivableCode = receivableCode;
  }

  public String getSupplierCode() {
    return supplierCode;
  }

  public void setSupplierCode(String supplierCode) {
    this.supplierCode = supplierCode;
  }

  public String getSupplierName() {
    return supplierName;
  }

  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public BigDecimal getReceivableAmount() {
    return receivableAmount;
  }

  public void setReceivableAmount(BigDecimal receivableAmount) {
    this.receivableAmount = receivableAmount;
  }

  public BigDecimal getWaitReceiveAmount() {
    return waitReceiveAmount;
  }

  public void setWaitReceiveAmount(BigDecimal waitReceiveAmount) {
    this.waitReceiveAmount = waitReceiveAmount;
  }

  public BigDecimal getReceivedAmount() {
    return receivedAmount;
  }

  public void setReceivedAmount(BigDecimal receivedAmount) {
    this.receivedAmount = receivedAmount;
  }

  public Integer getReceivableStatus() {
    return receivableStatus;
  }

  public void setReceivableStatus(Integer receivableStatus) {
    this.receivableStatus = receivableStatus;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Date getReceivableTime() {
    return receivableTime;
  }

  public void setReceivableTime(Date receivableTime) {
    this.receivableTime = receivableTime;
  }
}
