package com.bizunited.empower.business.payment.feign;

import com.bizunited.empower.business.payment.feign.fallback.BankCardFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 银行卡信息远程调用
 * 从运营平台接口回去银行卡对应的信息
 *
 * @author Keller
 */
@FeignClient(name = "saas-bankCard", url = "${saas.baseUrl}", path = "/v1/cardInfo", fallback = BankCardFeignClientFallback.class)
public interface BankCardFeignClient {

  /**
   * 按照银行卡号查询信息
   * @param appId
   * @param sign
   * @param cardNum
   * @return
   */
  @PostMapping("")
  ResponseModel findByCardNumber(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String cardNum);

  /**
   * 按照银行卡号，通过中金接口添加白名单
   * @param appId
   * @param sign
   * @param json
   * @return
   */
  @PostMapping("addToWhiteList")
  ResponseModel addToWhiteList(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String json);

  /**
   * 按照银行卡号,通过中金接口移除加白名单
   * @param appId
   * @param sign
   * @return
   */
  @PostMapping("removeFromWhiteList")
  ResponseModel removeFromWhiteList(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String json);
}
