package com.bizunited.empower.business.payment.feign;

import com.bizunited.empower.business.payment.feign.fallback.ElectronicAccountFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 电子账户feign远程调用
 * @Author: Paul Chan
 * @Date: 2021/4/14 上午11:22
 */
@FeignClient(name = "saas-electronicAccount", url = "${saas.baseUrl}", path = "/v1/electronicAccount", fallback = ElectronicAccountFeignClientFallback.class)
public interface ElectronicAccountFeignClient {


  /**
   * 发起签约，给签约手机号发送短信验证码
   * @param appId
   * @param sign
   * @param signDto
   * @return
   */
  @PatchMapping("handleSign")
  ResponseModel handleSign(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String signDto);

  /**
   * 绑定银行卡
   * @return
   */
  @PatchMapping("handleTiedCardVerify")
  ResponseModel handleTiedCardVerify( @RequestParam("appId") String appId, @RequestParam("sign") String sign,
                                      @RequestBody String tiedCardVerifyDto);

  /**
   * 解绑银行卡
   *
   * @param appId
   * @param sign
   * @param tiedCardVerifyDto
   * @return
   */
  @PatchMapping("handleUntieCardVerify")
  ResponseModel handleUntieCardVerify(@RequestParam("appId") String appId, @RequestParam("sign") String sign,
                                      @RequestBody String tiedCardVerifyDto);

  /**
   * 获取签约地址
   * @param appId
   * @param sign
   * @param signDto
   * @return
   */
  @GetMapping("findVerifyAddress")
  ResponseModel findVerifyAddress( @RequestParam("appId") String appId, @RequestParam("sign") String sign,
                                   @RequestBody String signDto);


  /**
   * 更新银行卡信息
   * @param appId
   * @param sign
   * @param electronicAccount
   * @return
   */
  @PatchMapping("updateForTiedCard")
  ResponseModel updateForTiedCard(@RequestParam("appId") String appId, @RequestParam("sign") String sign,
                                  @RequestBody String electronicAccount);

  /**
   * 发起绑卡请求
   * @param appId
   * @param sign
   * @param tiedCardVerifyDto
   * @return
   */
  @PatchMapping("handleTiedCard")
  ResponseModel handleTiedCard(@RequestParam("appId") String appId, @RequestParam("sign") String sign,
                               @RequestBody String tiedCardVerifyDto);

  /**
   * 更新安全手机号
   * @param appId
   * @param sign
   * @param securePhoneDto
   * @return
   */
  @PatchMapping("/updateSecurePhone")
  ResponseModel updateSecurePhone(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String securePhoneDto);

}
