package com.bizunited.empower.business.payment.feign;

import com.bizunited.empower.business.payment.feign.fallback.ElectronicAccountInfoFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 电子账户feign远程调用
 * @Author: Paul Chan
 * @Date: 2021/4/14 上午11:22
 */
@FeignClient(name = "saas-electronicAccountInfo", url = "${saas.baseUrl}", path = "/v1/accountInfo", fallback = ElectronicAccountInfoFeignClientFallback.class)
public interface ElectronicAccountInfoFeignClient {

  /**
   * 新增
   * @param appId
   * @param sign
   * @param electronicAccount
   * @return
   */
  @PostMapping("")
  ResponseModel create(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String electronicAccount);

  /**
   * 更新
   * @param appId
   * @param sign
   * @param electronicAccount
   * @return
   */
  @PatchMapping("")
  ResponseModel update(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String electronicAccount);


}
