package com.bizunited.empower.business.payment.feign;

import com.bizunited.empower.business.payment.feign.fallback.ElectronicAccountRateFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 电子账户的费率远程调用
 * @Author: Paul Chan
 * @Date: 2021/4/27 下午1:56
 */
@FeignClient(name = "saas-electronicAccountRate", url = "${saas.baseUrl}", path = "/v1/electronicAccountRate", fallback = ElectronicAccountRateFeignClientFallback.class)
public interface ElectronicAccountRateFeignClient {

  /**
   * 获取费率
   * @param appId
   * @param sign
   * @param tenantCode
   * @return
   */
  @GetMapping("findByTenantCodeForSign")
  ResponseModel findByTenantCodeForSign(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestParam("tenantCode")  String tenantCode);

}
