package com.bizunited.empower.business.payment.feign;

import com.bizunited.empower.business.payment.feign.fallback.ExtractCashFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 提现统一入口远程调用
 * @Author: Paul Chan
 * @Date: 2021/4/28 下午2:07
 */
@FeignClient(name = "saas-extractCash", url = "${saas.baseUrl}", path = "/v1/extractCash", fallback = ExtractCashFeignClientFallback.class)
public interface ExtractCashFeignClient {

  /**
   * 发起提现
   * @param appId
   * @param sign
   * @param cashInfo
   * @return
   */
  @PostMapping("")
  ResponseModel extractCash(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestParam("cashInfo") String cashInfo);

}
