package com.bizunited.empower.business.payment.feign;

import com.bizunited.empower.business.payment.feign.fallback.PaymentFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *  支付远程调用
 *  调用运营平台聚合支付信息，获取支付对应返回的信息并提供给业务程序
 *
 * @author Keller
 */
@FeignClient(name = "saas-payment", url = "${saas.baseUrl}", path = "/v1/payment", fallback = PaymentFeignClientFallback.class)
public interface PaymentFeignClient {

  /**
   * 按照银行卡号，通过中金接口添加白名单
   * @param appId
   * @param sign
   * @param payInfo
   * @return
   */
  @PostMapping("")
  ResponseModel pay(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String payInfo);

  /**
   * 按照银行卡号，通过中金接口添加白名单
   * @param appId
   * @param sign
   * @param payInfo
   * @return
   */
  @PostMapping("cancel")
  ResponseModel cancel(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String payInfo);


}
