package com.bizunited.empower.business.payment.feign;

import com.bizunited.empower.business.payment.feign.fallback.RefundFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *  退款远程调用
 *  调用运营平台退款接口信息，获取退款对应返回的信息并提供给业务程序
 *
 * @author Keller
 */
@FeignClient(name = "saas-refund", url = "${saas.baseUrl}", path = "/v1/refund", fallback = RefundFeignClientFallback.class)
public interface RefundFeignClient {

  /**
   * 按照银行卡号，通过中金接口添加白名单
   * @param appId
   * @param sign
   * @param refundInfo
   * @return
   */
  @PostMapping("")
  ResponseModel refund(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestBody String refundInfo);

}
